/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.KeyValueWrapper;
import org.infinispan.persistence.jpa.JpaKeyValueWrapper;
import org.infinispan.persistence.jpa.JpaSCI;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfigurationBuilder;
import org.infinispan.persistence.jpa.entity.KeyValueEntity;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.SingleCacheManagerTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jpa.JpaStoreCompatibilityTest")
public class JpaStoreCompatibilityTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "jps-store-cache";
    private static final String DB_FILE_NAME = "jpa_db.mv.db";
    private static final String DATA_10_1_FOLDER = "10_1_x_jpa_data";
    private static final int NUMBER_KEYS = 10;
    private final KeyValueWrapper<String, String, KeyValueEntity> valueWrapper = JpaKeyValueWrapper.INSTANCE;
    private String tmpDirectory;

    @Test
    public void testReadWriteFrom101() throws Exception {
        String key;
        int i;
        new File(this.tmpDirectory).mkdirs();
        String src = Paths.get(DATA_10_1_FOLDER, DB_FILE_NAME).toString();
        InputStream is = FileLookupFactory.newInstance().lookupFile(src, Thread.currentThread().getContextClassLoader());
        File f = new File(Paths.get(this.tmpDirectory, new String[0]).toFile(), DB_FILE_NAME);
        Files.copy(is, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Cache cache = this.cacheManager.getCache(CACHE_NAME);
        for (i = 0; i < 10; ++i) {
            key = this.key(i);
            if (i % 2 != 0) {
                AssertJUnit.assertNull((String)("Expected null value for key " + key), (Object)cache.get((Object)key));
                continue;
            }
            AssertJUnit.assertEquals((String)("Wrong value read for key " + key), (String)JpaStoreCompatibilityTest.value(i), (String)((String)this.valueWrapper.unwrap((Object)((KeyValueEntity)cache.get((Object)key)))));
        }
        for (i = 0; i < 10; ++i) {
            if (i % 2 == 0) continue;
            key = this.key(i);
            cache.put((Object)key, (Object)((KeyValueEntity)this.valueWrapper.wrap((Object)key, (Object)JpaStoreCompatibilityTest.value(i))));
        }
        for (i = 0; i < 10; ++i) {
            key = this.key(i);
            AssertJUnit.assertEquals((String)("Wrong value read for key " + key), (String)JpaStoreCompatibilityTest.value(i), (String)((String)this.valueWrapper.unwrap((Object)((KeyValueEntity)cache.get((Object)key)))));
        }
    }

    private String key(int index) {
        return "key-" + index;
    }

    private static String value(int index) {
        return "value-" + index;
    }

    protected void setup() throws Exception {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
        Util.recursiveFileRemove((String)this.tmpDirectory);
        new File(this.tmpDirectory).mkdirs();
        this.log.debugf("Using tmpDirectory=%s", (Object)this.tmpDirectory);
        super.setup();
    }

    protected void teardown() {
        super.teardown();
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.LOCAL);
        builder.clustering().hash().numSegments(4);
        ((JpaStoreConfigurationBuilder)builder.persistence().addStore(JpaStoreConfigurationBuilder.class)).entityClass(KeyValueEntity.class).storeMetadata(true).persistenceUnitName("org.infinispan.persistence.jpa.compatibility_test").segmented(false);
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalBuilder.globalState().persistentLocation(CommonsTestingUtil.tmpDirectory());
        globalBuilder.serialization().addContextInitializer((SerializationContextInitializer)JpaSCI.INSTANCE);
        DefaultCacheManager cacheManager = new DefaultCacheManager(globalBuilder.build());
        cacheManager.defineConfiguration(CACHE_NAME, builder.build());
        return cacheManager;
    }
}

