/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa;

import java.util.concurrent.ExecutorService;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.marshall.persistence.impl.MarshalledEntryFactoryImpl;
import org.infinispan.persistence.DummyInitializationContext;
import org.infinispan.persistence.jpa.JpaSCI;
import org.infinispan.persistence.jpa.JpaStore;
import org.infinispan.persistence.jpa.TestObject;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfigurationBuilder;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractJpaStoreTest
extends AbstractInfinispanTest {
    protected static final String PERSISTENCE_UNIT_NAME = "org.infinispan.persistence.jpa";
    protected EmbeddedCacheManager cm;
    protected JpaStore<Object, Object> cs;
    protected PersistenceMarshaller marshaller;
    protected MarshallableEntryFactory entryFactory;
    protected BlockingManager blockingManager;

    protected AbstractJpaStoreTest() {
    }

    protected EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)JpaSCI.INSTANCE);
    }

    protected JpaStore createCacheStore(GlobalConfiguration gc) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((JpaStoreConfigurationBuilder)builder.persistence().addStore(JpaStoreConfigurationBuilder.class)).persistenceUnitName(PERSISTENCE_UNIT_NAME).entityClass(this.getEntityClass()).segmented(false);
        JpaStore store = new JpaStore();
        store.init((InitializationContext)new DummyInitializationContext((StoreConfiguration)((StoreConfigurationBuilder)builder.persistence().stores().get(0)).create(), this.cm.getCache(), this.marshaller, null, this.entryFactory, (ExecutorService)new WithinThreadExecutor(), gc, this.blockingManager, null, this.cm.getGlobalComponentRegistry().getTimeService()));
        store.start();
        AssertJUnit.assertNotNull((Object)store.getEntityManagerFactory());
        return store;
    }

    protected abstract Class<?> getEntityClass();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        try {
            this.cm = this.createCacheManager();
            this.marshaller = this.cm.getCache().getAdvancedCache().getComponentRegistry().getPersistenceMarshaller();
            this.entryFactory = new MarshalledEntryFactoryImpl((Marshaller)this.marshaller);
            this.blockingManager = (BlockingManager)this.cm.getGlobalComponentRegistry().getComponent(BlockingManager.class);
            this.cs = this.createCacheStore(this.cm.getCacheManagerConfiguration());
            this.cs.clear();
        }
        catch (Exception e) {
            log.warn((Object)"Error during test setup", (Throwable)e);
            throw e;
        }
    }

    @AfterMethod(alwaysRun=true)
    public void stopMarshaller() {
        if (this.cs != null) {
            this.cs.stop();
        }
        if (this.cm != null) {
            this.cm.stop();
        }
    }

    protected MarshallableEntry createEntry(Object key, Object value) {
        return this.entryFactory.create(key, value);
    }

    protected MarshallableEntry createEntry(TestObject obj) {
        return this.createEntry(obj.getKey(), obj.getValue());
    }
}

