/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa.entity;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import org.infinispan.persistence.jpa.entity.Address;
import org.infinispan.protostream.annotations.ProtoField;

@Entity
public class Person {
    @Id
    private String id;
    private String name;
    @ElementCollection(fetch=FetchType.EAGER)
    private Set<String> nickNames;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="zipCode", column=@Column(name="zip"))})
    private Address address;
    @ElementCollection(fetch=FetchType.EAGER)
    private Set<Address> secondaryAddresses;

    @ProtoField(value=1)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ProtoField(value=2)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ProtoField(number=3, collectionImplementation=HashSet.class)
    public Set<String> getNickNames() {
        return this.nickNames;
    }

    public void setNickNames(Set<String> nickNames) {
        this.nickNames = nickNames;
    }

    @ProtoField(value=4)
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    @ProtoField(number=5, collectionImplementation=HashSet.class)
    public Set<Address> getSecondaryAddresses() {
        return this.secondaryAddresses;
    }

    public void setSecondaryAddresses(Set<Address> secondaryAddresses) {
        this.secondaryAddresses = secondaryAddresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        if (this.id != null ? !this.id.equals(person.getId()) : person.getId() != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(person.getName()) : person.getName() != null) {
            return false;
        }
        if (this.nickNames != null && !this.nickNames.isEmpty() ? !this.nickNames.equals(person.getNickNames()) : person.getNickNames() != null && !person.getNickNames().isEmpty()) {
            return false;
        }
        if (this.address != null ? !this.address.equals(person.getAddress()) : person.getAddress() != null) {
            return false;
        }
        return !(this.secondaryAddresses != null && !this.secondaryAddresses.isEmpty() ? !this.secondaryAddresses.equals(person.getSecondaryAddresses()) : person.getSecondaryAddresses() != null && !person.getSecondaryAddresses().isEmpty());
    }

    public int hashCode() {
        int prime = 31;
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.nickNames != null ? this.nickNames.hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.secondaryAddresses != null ? this.secondaryAddresses.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Person{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", nickNames=" + this.nickNames + ", address=" + this.address + ", secondaryAddresses=" + this.secondaryAddresses + '}';
    }
}

