/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa.impl;

import java.util.concurrent.atomic.LongAdder;

public class Stats {
    private final Operation entityFind = new Operation();
    private final Operation entityMerge = new Operation();
    private final Operation entityRemove = new Operation();
    private final Operation metadataFind = new Operation();
    private final Operation metadataMerge = new Operation();
    private final Operation metadataRemove = new Operation();
    private final Operation txReadCommitted = new Operation();
    private final Operation txWriteCommitted = new Operation();
    private final Operation txRemoveCommitted = new Operation();
    private final Operation txBatchWriteCommitted = new Operation();
    private final Operation txBatchRemoveCommitted = new Operation();
    private final Operation txReadFailed = new Operation();
    private final Operation txWriteFailed = new Operation();
    private final Operation txRemoveFailed = new Operation();
    private final Operation txBatchWriteFailed = new Operation();
    private final Operation txBatchRemoveFailed = new Operation();

    public void addEntityMerge(long duration) {
        this.entityMerge.add(duration);
    }

    public void addMetadataMerge(long duration) {
        this.metadataMerge.add(duration);
    }

    public void addWriteTxCommited(long duration) {
        this.txWriteCommitted.add(duration);
    }

    public void addWriteTxFailed(long duration) {
        this.txWriteFailed.add(duration);
    }

    public void addEntityFind(long duration) {
        this.entityFind.add(duration);
    }

    public void addMetadataFind(long duration) {
        this.metadataFind.add(duration);
    }

    public void addReadTxCommitted(long duration) {
        this.txReadCommitted.add(duration);
    }

    public void addReadTxFailed(long duration) {
        this.txReadFailed.add(duration);
    }

    public void addEntityRemove(long duration) {
        this.entityRemove.add(duration);
    }

    public void addMetadataRemove(long duration) {
        this.metadataRemove.add(duration);
    }

    public void addRemoveTxCommitted(long duration) {
        this.txRemoveCommitted.add(duration);
    }

    public void addRemoveTxFailed(long duration) {
        this.txRemoveFailed.add(duration);
    }

    public void addBatchWriteTxCommitted(long duration) {
        this.txBatchWriteCommitted.add(duration);
    }

    public void addBatchWriteTxFailed(long duration) {
        this.txBatchWriteFailed.add(duration);
    }

    public void addBatchRemoveTxCommitted(long duration) {
        this.txBatchRemoveCommitted.add(duration);
    }

    public void addBatchRemoveTxFailed(long duration) {
        this.txBatchRemoveFailed.add(duration);
    }

    public String toString() {
        return "Stats{\nentityFind=" + this.entityFind + "\nentityMerge=" + this.entityMerge + "\nentityRemove=" + this.entityRemove + "\nmetadataFind=" + this.metadataFind + "\nmetadataMerge=" + this.metadataMerge + "\nmetadataRemove=" + this.metadataRemove + "\ntxReadCommitted=" + this.txReadCommitted + "\ntxWriteCommitted=" + this.txWriteCommitted + "\ntxRemoveCommitted=" + this.txRemoveCommitted + "\ntxBatchWriteCommitted=" + this.txBatchWriteCommitted + "\ntxBatchRemoveCommitted=" + this.txBatchRemoveCommitted + "\ntxReadFailed=" + this.txReadFailed + "\ntxWriteFailed=" + this.txWriteFailed + "\ntxRemoveFailed=" + this.txRemoveFailed + "\ntxBatchWriteFailed=" + this.txBatchWriteFailed + "\ntxBatchRemoveFailed=" + this.txBatchRemoveFailed + '}';
    }

    private class Operation {
        final LongAdder count = new LongAdder();
        final LongAdder sum = new LongAdder();

        private Operation() {
        }

        void add(long duration) {
            this.count.increment();
            this.sum.add(duration);
        }

        public String toString() {
            long count = this.count.sum();
            long sum = this.sum.sum();
            return String.format("[count=%d, avg=%.2f ms]", count, count == 0L ? Double.NaN : (double)sum / (1000000.0 * (double)count));
        }
    }
}

