/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa.configuration;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.persistence.jpa.JpaSCI;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfiguration;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfigurationBuilder;
import org.infinispan.persistence.jpa.entity.User;
import org.infinispan.persistence.jpa.entity.Vehicle;
import org.infinispan.persistence.jpa.entity.VehicleId;
import org.infinispan.protostream.SerializationContextInitializer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.JpaConfigurationTest")
public class JpaConfigurationTest {
    private static final String PERSISTENCE_UNIT_NAME = "org.infinispan.persistence.jpa.configurationTest";

    public void testConfigBuilder() {
        GlobalConfiguration globalConfig = new GlobalConfigurationBuilder().transport().defaultTransport().serialization().addContextInitializer((SerializationContextInitializer)JpaSCI.INSTANCE).build();
        Configuration cacheConfig = ((JpaStoreConfigurationBuilder)((JpaStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(JpaStoreConfigurationBuilder.class)).segmented(false)).persistenceUnitName(PERSISTENCE_UNIT_NAME).entityClass(User.class).build();
        StoreConfiguration storeConfiguration = (StoreConfiguration)cacheConfig.persistence().stores().get(0);
        AssertJUnit.assertTrue((boolean)(storeConfiguration instanceof JpaStoreConfiguration));
        JpaStoreConfiguration jpaCacheLoaderConfig = (JpaStoreConfiguration)storeConfiguration;
        AssertJUnit.assertEquals((String)PERSISTENCE_UNIT_NAME, (String)jpaCacheLoaderConfig.persistenceUnitName());
        AssertJUnit.assertEquals(User.class, (Object)jpaCacheLoaderConfig.entityClass());
        DefaultCacheManager cacheManager = new DefaultCacheManager(globalConfig);
        cacheManager.defineConfiguration("userCache", cacheConfig);
        cacheManager.start();
        Cache userCache = cacheManager.getCache("userCache");
        User user = new User();
        user.setUsername("rtsang");
        user.setFirstName("Ray");
        user.setLastName("Tsang");
        userCache.put((Object)user.getUsername(), (Object)user);
        userCache.stop();
        cacheManager.stop();
    }

    protected void validateConfig(Cache<VehicleId, Vehicle> vehicleCache) {
        StoreConfiguration config = (StoreConfiguration)vehicleCache.getCacheConfiguration().persistence().stores().get(0);
        AssertJUnit.assertTrue((boolean)(config instanceof JpaStoreConfiguration));
        JpaStoreConfiguration jpaConfig = (JpaStoreConfiguration)config;
        AssertJUnit.assertEquals((long)1L, (long)jpaConfig.batchSize());
        AssertJUnit.assertEquals(Vehicle.class, (Object)jpaConfig.entityClass());
        AssertJUnit.assertEquals((String)PERSISTENCE_UNIT_NAME, (String)jpaConfig.persistenceUnitName());
    }

    public void testXmlConfig() throws IOException {
        DefaultCacheManager cacheManager = new DefaultCacheManager("configs/all/jpa-config.xml");
        Cache vehicleCache = cacheManager.getCache("vehicleCache");
        this.validateConfig((Cache<VehicleId, Vehicle>)vehicleCache);
        Vehicle v = new Vehicle();
        v.setId(new VehicleId("NC", "123456"));
        v.setColor("BLUE");
        vehicleCache.put((Object)v.getId(), (Object)v);
        vehicleCache.stop();
        cacheManager.stop();
    }
}

