/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jpa;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.GeneratedValue;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.LockSupportCacheStore;
import org.infinispan.loaders.jpa.EntityManagerFactoryRegistry;
import org.infinispan.loaders.jpa.JpaCacheLoaderException;
import org.infinispan.loaders.jpa.JpaCacheStoreConfig;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.InfinispanCollections;

@CacheLoaderMetadata(configurationClass=JpaCacheStoreConfig.class)
public class JpaCacheStore
extends LockSupportCacheStore<Integer> {
    private JpaCacheStoreConfig config;
    private AdvancedCache<?, ?> cache;
    private EntityManagerFactory emf;
    private EntityManagerFactoryRegistry emfRegistry;
    private static final byte BINARY_STREAM_DELIMITER = 100;

    public void init(CacheLoaderConfig config, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(config, cache, m);
        this.cache = cache.getAdvancedCache();
        this.emfRegistry = (EntityManagerFactoryRegistry)this.cache.getComponentRegistry().getGlobalComponentRegistry().getComponent(EntityManagerFactoryRegistry.class);
        this.config = (JpaCacheStoreConfig)config;
    }

    public void start() throws CacheLoaderException {
        EntityType mt;
        super.start();
        try {
            this.emf = this.emfRegistry.getEntityManagerFactory(this.config.getPersistenceUnitName());
        }
        catch (PersistenceException e) {
            throw new JpaCacheLoaderException("Persistence Unit [" + this.config.getPersistenceUnitName() + "] not found", e);
        }
        try {
            mt = this.emf.getMetamodel().entity(this.config.getEntityClass());
        }
        catch (IllegalArgumentException e) {
            throw new JpaCacheLoaderException("Entity class [" + this.config.getEntityClassName() + " specified in configuration is not recognized by the EntityManagerFactory with Persistence Unit [" + this.config.getPersistenceUnitName() + "]", e);
        }
        if (!(mt instanceof IdentifiableType)) {
            throw new JpaCacheLoaderException("Entity class must have one and only one identifier (@Id or @EmbeddedId)");
        }
        IdentifiableType it = (IdentifiableType)mt;
        if (!it.hasSingleIdAttribute()) {
            throw new JpaCacheLoaderException("Entity class has more than one identifier.  It must have only one identifier.");
        }
        Type idType = it.getIdType();
        Class idJavaType = idType.getJavaType();
        if (idJavaType.isAnnotationPresent(GeneratedValue.class)) {
            throw new JpaCacheLoaderException("Entity class has one identifier, but it must not have @GeneratedValue annotation");
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public void stop() throws CacheLoaderException {
        try {
            this.emfRegistry.closeEntityManagerFactory(this.config.getPersistenceUnitName());
            super.stop();
        }
        catch (Throwable t) {
            throw new CacheLoaderException("Exceptions occurred while stopping store", t);
        }
    }

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return JpaCacheStoreConfig.class;
    }

    protected boolean isValidKeyType(Object key) {
        return this.emf.getMetamodel().entity(this.config.getEntityClass()).getIdType().getJavaType().isAssignableFrom(key.getClass());
    }

    protected void clearLockSafe() throws CacheLoaderException {
        EntityManager em = this.emf.createEntityManager();
        EntityTransaction txn = em.getTransaction();
        try {
            txn.begin();
            String name = em.getMetamodel().entity(this.config.getEntityClass()).getName();
            Query query = em.createQuery("DELETE FROM " + name);
            query.executeUpdate();
            txn.commit();
        }
        catch (Exception e) {
            if (txn != null && txn.isActive()) {
                txn.rollback();
            }
            throw new CacheLoaderException("Exception caught in clear()", (Throwable)e);
        }
        finally {
            em.close();
        }
    }

    protected Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException {
        return this.loadLockSafe(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<InternalCacheEntry> loadLockSafe(int maxEntries) throws CacheLoaderException {
        if (maxEntries == 0) {
            return InfinispanCollections.emptySet();
        }
        EntityManager em = this.emf.createEntityManager();
        try {
            List list;
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(this.config.getEntityClass());
            cq.select((Selection)cq.from(this.config.getEntityClass()));
            TypedQuery q = em.createQuery(cq);
            if (maxEntries > 0) {
                q.setMaxResults(maxEntries);
            }
            if ((list = q.getResultList()) == null || list.isEmpty()) {
                Set<InternalCacheEntry> set = Collections.emptySet();
                return set;
            }
            PersistenceUnitUtil util = this.emf.getPersistenceUnitUtil();
            HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>(list.size());
            for (Object o : list) {
                Object key = util.getIdentifier(o);
                result.add((InternalCacheEntry)new ImmortalCacheEntry(key, o));
            }
            HashSet<InternalCacheEntry> hashSet = result;
            return hashSet;
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Object> loadAllKeysLockSafe(Set<Object> keysToExclude) throws CacheLoaderException {
        EntityManager em = this.emf.createEntityManager();
        try {
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery cq = cb.createTupleQuery();
            Root root = cq.from(this.config.getEntityClass());
            Type idType = root.getModel().getIdType();
            SingularAttribute idAttr = root.getModel().getId(idType.getJavaType());
            cq.multiselect(new Selection[]{root.get(idAttr)});
            List tuples = em.createQuery(cq).getResultList();
            HashSet<Object> keys = new HashSet<Object>();
            for (Tuple t : tuples) {
                Object id = t.get(0);
                if (!this.includeKey(id, keysToExclude)) continue;
                keys.add(id);
            }
            HashSet<Object> hashSet = keys;
            return hashSet;
        }
        finally {
            em.close();
        }
    }

    protected void toStreamLockSafe(ObjectOutput oos) throws CacheLoaderException {
        EntityManager em = this.emf.createEntityManager();
        try {
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(this.config.getEntityClass());
            cq.select((Selection)cq.from(this.config.getEntityClass()));
            TypedQuery q = em.createQuery(cq);
            for (Object o : q.getResultList()) {
                this.marshaller.objectToObjectStream(o, oos);
            }
            this.marshaller.objectToObjectStream((Object)100, oos);
        }
        catch (IOException e) {
            throw new CacheLoaderException("IO Exception in toStreamLockSafe", (Throwable)e);
        }
        finally {
            em.close();
        }
    }

    protected void fromStreamLockSafe(ObjectInput ois) throws CacheLoaderException {
        long batchSize = 0L;
        EntityManager em = this.emf.createEntityManager();
        EntityTransaction txn = em.getTransaction();
        try {
            Object o = this.marshaller.objectFromObjectStream(ois);
            txn.begin();
            while (o != null && o.getClass().isAnnotationPresent(Entity.class)) {
                em.merge(o);
                if (++batchSize >= this.config.getBatchSize()) {
                    em.flush();
                    em.clear();
                    batchSize = 0L;
                }
                o = this.marshaller.objectFromObjectStream(ois);
            }
            txn.commit();
        }
        catch (InterruptedException e) {
            if (txn != null && txn.isActive()) {
                txn.rollback();
            }
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            if (txn != null && txn.isActive()) {
                txn.rollback();
            }
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            em.close();
        }
    }

    protected boolean removeLockSafe(Object key, Integer lockingKey) throws CacheLoaderException {
        if (!this.isValidKeyType(key)) {
            return false;
        }
        EntityManager em = this.emf.createEntityManager();
        try {
            Object o = em.find(this.config.getEntityClass(), key);
            if (o == null) {
                boolean bl = false;
                return bl;
            }
            EntityTransaction txn = em.getTransaction();
            try {
                txn.begin();
                em.remove(o);
                txn.commit();
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                if (txn != null && txn.isActive()) {
                    txn.rollback();
                }
                throw new CacheLoaderException("Exception caught in removeLockSafe()", (Throwable)e);
            }
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeLockSafe(InternalCacheEntry entry, Integer lockingKey) throws CacheLoaderException {
        EntityManager em = this.emf.createEntityManager();
        Object o = entry.getValue();
        try {
            if (!this.config.getEntityClass().isAssignableFrom(o.getClass())) {
                throw new JpaCacheLoaderException("This cache is configured with JPA CacheStore to only store values of type " + this.config.getEntityClassName());
            }
            EntityTransaction txn = em.getTransaction();
            Object id = this.emf.getPersistenceUnitUtil().getIdentifier(o);
            if (!entry.getKey().equals(id)) {
                throw new JpaCacheLoaderException("Entity id value must equal to key of cache entry: key = [" + entry.getKey() + "], id = [" + id + "]");
            }
            try {
                txn.begin();
                em.merge(o);
                txn.commit();
            }
            catch (Exception e) {
                if (txn != null && txn.isActive()) {
                    txn.rollback();
                }
                throw new CacheLoaderException("Exception caught in store()", (Throwable)e);
            }
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalCacheEntry loadLockSafe(Object key, Integer lockingKey) throws CacheLoaderException {
        if (!this.isValidKeyType(key)) {
            return null;
        }
        EntityManager em = this.emf.createEntityManager();
        try {
            Object o = em.find(this.config.getEntityClass(), key);
            if (o == null) {
                InternalCacheEntry internalCacheEntry = null;
                return internalCacheEntry;
            }
            ImmortalCacheEntry immortalCacheEntry = new ImmortalCacheEntry(key, o);
            return immortalCacheEntry;
        }
        finally {
            em.close();
        }
    }

    protected Integer getLockFromKey(Object key) throws CacheLoaderException {
        return key.hashCode() & 0xFFFFFC00;
    }

    protected boolean includeKey(Object key, Set<Object> keysToExclude) {
        return keysToExclude == null || !keysToExclude.contains(key);
    }

    protected void purgeInternal() throws CacheLoaderException {
    }
}

