/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jpa.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser53;
import org.infinispan.loaders.jpa.configuration.Attribute;
import org.infinispan.loaders.jpa.configuration.Element;
import org.infinispan.loaders.jpa.configuration.JpaCacheStoreConfigurationBuilder;
import org.infinispan.util.StringPropertyReplacer;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class JpaCacheStoreConfigurationParser53
implements ConfigurationParser<ConfigurationBuilderHolder> {
    public Namespace[] getSupportedNamespaces() {
        return new Namespace[]{new Namespace("urn:infinispan:config", "jpa", Element.JPA_STORE.getLocalName(), 5, 3), new Namespace("", Element.JPA_STORE.getLocalName(), 0, 0)};
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case JPA_STORE: {
                this.parseJpaCacheStore(reader, (JpaCacheStoreConfigurationBuilder)builder.loaders().addLoader(JpaCacheStoreConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseJpaCacheStore(XMLExtendedStreamReader reader, JpaCacheStoreConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENTITY_CLASS_NAME: {
                    Class<?> clazz;
                    try {
                        clazz = this.getClass().getClassLoader().loadClass(value);
                    }
                    catch (ClassNotFoundException e) {
                        throw new XMLStreamException("Class " + value + " specified in entityClassName is not found", e);
                    }
                    builder.entityClass(clazz);
                    continue block7;
                }
                case BATCH_SIZE: {
                    builder.batchSize(Long.valueOf(value));
                    continue block7;
                }
                case PERSISTENCE_UNIT_NAME: {
                    builder.persistenceUnitName(value);
                    continue block7;
                }
                default: {
                    Parser53.parseCommonStoreAttributes((XMLExtendedStreamReader)reader, (int)i, (CacheStoreConfigurationBuilder)builder);
                }
            }
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }
}

