/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jpa;

import java.util.Properties;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.loaders.LockSupportCacheStoreConfig;
import org.infinispan.loaders.jpa.JpaCacheStore;

public class JpaCacheStoreConfig
extends LockSupportCacheStoreConfig {
    private static final long serialVersionUID = -8588748696540797858L;
    public static final long DEFAULT_BATCH_SIZE = 100L;
    private String persistenceUnitName;
    private String entityClassName;
    private Class<?> entityClass;
    private long batchSize = 100L;

    public JpaCacheStoreConfig() {
        this.cacheLoaderClassName = JpaCacheStore.class.getName();
    }

    protected JpaCacheStoreConfig(JpaCacheStoreConfig config) {
        Properties p = this.getProperties();
        this.setProperty(config.getPersistenceUnitName(), "persistenceUnitName", p);
        this.setProperty(config.getEntityClassName(), "entityClassName", p);
        this.setProperty(String.valueOf(config.getBatchSize()), "batchSize", p);
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public String getEntityClassName() {
        return this.entityClassName;
    }

    public void setEntityClassName(String entityClassName) throws ClassNotFoundException {
        this.entityClassName = entityClassName;
        this.entityClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(entityClassName);
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.entityClassName = entityClass.getName();
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }

    protected void setProperty(String properyValue, String propertyName, Properties p) {
        if (properyValue != null) {
            try {
                p.setProperty(propertyName, properyValue);
            }
            catch (UnsupportedOperationException e) {
                TypedProperties writableProperties = new TypedProperties(p);
                writableProperties.setProperty(propertyName, properyValue);
                this.setProperties((Properties)writableProperties);
            }
        }
    }
}

