/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.GeneratedValue;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.executors.ExecutorAllCompletionService;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.jpa.EntityManagerFactoryRegistry;
import org.infinispan.persistence.jpa.JpaStoreException;
import org.infinispan.persistence.jpa.MetadataEntity;
import org.infinispan.persistence.jpa.Stats;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfiguration;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ConfiguredBy(value=JpaStoreConfiguration.class)
public class JpaStore
implements AdvancedLoadWriteStore {
    private static final Log log = LogFactory.getLog(JpaStore.class);
    private static boolean trace = log.isTraceEnabled();
    private JpaStoreConfiguration configuration;
    private EntityManagerFactory emf;
    private EntityManagerFactoryRegistry emfRegistry;
    private StreamingMarshaller marshaller;
    private MarshalledEntryFactory marshallerEntryFactory;
    private TimeService timeService;
    private Stats stats = new Stats();

    public void init(InitializationContext ctx) {
        this.configuration = (JpaStoreConfiguration)ctx.getConfiguration();
        this.emfRegistry = (EntityManagerFactoryRegistry)ctx.getCache().getAdvancedCache().getComponentRegistry().getGlobalComponentRegistry().getComponent(EntityManagerFactoryRegistry.class);
        this.marshallerEntryFactory = ctx.getMarshalledEntryFactory();
        this.marshaller = ctx.getMarshaller();
        this.timeService = ctx.getTimeService();
    }

    public void start() {
        EntityType mt;
        try {
            this.emf = this.emfRegistry.getEntityManagerFactory(this.configuration.persistenceUnitName());
        }
        catch (javax.persistence.PersistenceException e) {
            throw new JpaStoreException("Persistence Unit [" + this.configuration.persistenceUnitName() + "] not found", e);
        }
        try {
            mt = this.emf.getMetamodel().entity(this.configuration.entityClass());
        }
        catch (IllegalArgumentException e) {
            throw new JpaStoreException("Entity class [" + this.configuration.entityClass().getName() + " specified in configuration is not recognized by the EntityManagerFactory with Persistence Unit [" + this.configuration.persistenceUnitName() + "]", e);
        }
        if (!(mt instanceof IdentifiableType)) {
            throw new JpaStoreException("Entity class must have one and only one identifier (@Id or @EmbeddedId)");
        }
        IdentifiableType it = (IdentifiableType)mt;
        if (!it.hasSingleIdAttribute()) {
            throw new JpaStoreException("Entity class has more than one identifier.  It must have only one identifier.");
        }
        Type idType = it.getIdType();
        Class idJavaType = idType.getJavaType();
        if (idJavaType.isAnnotationPresent(GeneratedValue.class)) {
            throw new JpaStoreException("Entity class has one identifier, but it must not have @GeneratedValue annotation");
        }
    }

    EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public void stop() {
        try {
            this.emfRegistry.closeEntityManagerFactory(this.configuration.persistenceUnitName());
        }
        catch (Exception e) {
            throw new JpaStoreException("Exceptions occurred while stopping store", e);
        }
        finally {
            log.info((Object)("JPA Store stopped, stats: " + this.stats));
        }
    }

    protected boolean isValidKeyType(Object key) {
        return this.emf.getMetamodel().entity(this.configuration.entityClass()).getIdType().getJavaType().isAssignableFrom(key.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        EntityManager em = this.emf.createEntityManager();
        EntityTransaction txn = em.getTransaction();
        try {
            int i = 0;
            while (true) {
                txn.begin();
                try {
                    log.trace((Object)"Clearing JPA Store");
                    String entityTable = em.getMetamodel().entity(this.configuration.entityClass()).getName();
                    List items = em.createQuery("FROM " + entityTable).getResultList();
                    for (Object o : items) {
                        em.remove(o);
                    }
                    if (this.configuration.storeMetadata()) {
                        String metadataTable = em.getMetamodel().entity(MetadataEntity.class).getName();
                        Query clearMetadata = em.createQuery("DELETE FROM " + metadataTable);
                        clearMetadata.executeUpdate();
                    }
                    txn.commit();
                    em.clear();
                    break;
                }
                catch (Exception e) {
                    log.trace((Object)"Failed to clear store", (Throwable)e);
                    if (i >= 10) {
                        throw new JpaStoreException("Exception caught in clear()", e);
                    }
                }
                finally {
                    if (txn != null && txn.isActive()) {
                        txn.rollback();
                    }
                }
                ++i;
            }
        }
        finally {
            em.close();
        }
    }

    /*
     * Loose catch block
     */
    public boolean delete(Object key) {
        if (!this.isValidKeyType(key)) {
            return false;
        }
        EntityManager em = this.emf.createEntityManager();
        try {
            long entityFindBegin = this.timeService.time();
            Object entity = em.find(this.configuration.entityClass(), key);
            this.stats.addEntityFind(this.timeService.time() - entityFindBegin);
            if (entity == null) {
                boolean bl = false;
                return bl;
            }
            MetadataEntity metadata = null;
            if (this.configuration.storeMetadata()) {
                byte[] keyBytes;
                try {
                    keyBytes = this.marshaller.objectToByteBuffer(key);
                }
                catch (Exception e) {
                    throw new JpaStoreException("Failed to marshall key", e);
                }
                long metadataFindBegin = this.timeService.time();
                metadata = (MetadataEntity)em.find(MetadataEntity.class, (Object)keyBytes);
                this.stats.addMetadataFind(this.timeService.time() - metadataFindBegin);
            }
            EntityTransaction txn = em.getTransaction();
            if (trace) {
                log.trace((Object)("Removing " + entity + "(" + this.toString(metadata) + ")"));
            }
            long txnBegin = this.timeService.time();
            txn.begin();
            try {
                long entityRemoveBegin = this.timeService.time();
                em.remove(entity);
                this.stats.addEntityRemove(this.timeService.time() - entityRemoveBegin);
                if (metadata != null) {
                    long metadataRemoveBegin = this.timeService.time();
                    em.remove((Object)metadata);
                    this.stats.addMetadataRemove(this.timeService.time() - metadataRemoveBegin);
                }
                txn.commit();
                this.stats.addRemoveTxCommitted(this.timeService.time() - txnBegin);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                this.stats.addRemoveTxFailed(this.timeService.time() - txnBegin);
                throw new JpaStoreException("Exception caught in delete()", e);
            }
            finally {
                if (txn != null && txn.isActive()) {
                    txn.rollback();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MarshalledEntry entry) {
        EntityManager em = this.emf.createEntityManager();
        Object entity = entry.getValue();
        MetadataEntity metadata = this.configuration.storeMetadata() ? new MetadataEntity(entry.getKeyBytes(), entry.getMetadataBytes(), entry.getMetadata() == null ? Long.MAX_VALUE : entry.getMetadata().expiryTime()) : null;
        try {
            if (!this.configuration.entityClass().isAssignableFrom(entity.getClass())) {
                throw new JpaStoreException(String.format("This cache is configured with JPA CacheStore to only store values of type %s - cannot write %s = %s", this.configuration.entityClass().getName(), entity, entity.getClass().getName()));
            }
            EntityTransaction txn = em.getTransaction();
            Object id = this.emf.getPersistenceUnitUtil().getIdentifier(entity);
            if (!entry.getKey().equals(id)) {
                throw new JpaStoreException("Entity id value must equal to key of cache entry: key = [" + entry.getKey() + "], id = [" + id + "]");
            }
            long txnBegin = this.timeService.time();
            try {
                if (trace) {
                    log.trace((Object)("Writing " + entity + "(" + this.toString(metadata) + ")"));
                }
                txn.begin();
                long entityMergeBegin = this.timeService.time();
                em.merge(entity);
                this.stats.addEntityMerge(this.timeService.time() - entityMergeBegin);
                if (metadata != null && metadata.hasBytes()) {
                    long metadataMergeBegin = this.timeService.time();
                    em.merge((Object)metadata);
                    this.stats.addMetadataMerge(this.timeService.time() - metadataMergeBegin);
                }
                txn.commit();
                this.stats.addWriteTxCommited(this.timeService.time() - txnBegin);
            }
            catch (Exception e) {
                this.stats.addWriteTxFailed(this.timeService.time() - txnBegin);
                throw new JpaStoreException("Exception caught in write()", e);
            }
            finally {
                if (txn != null && txn.isActive()) {
                    txn.rollback();
                }
            }
        }
        finally {
            em.close();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean contains(Object key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public MarshalledEntry load(Object key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(AdvancedCacheLoader.KeyFilter filter, final AdvancedCacheLoader.CacheLoaderTask task, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        ExecutorAllCompletionService eacs = new ExecutorAllCompletionService(executor);
        final TaskContextImpl taskContext = new TaskContextImpl();
        EntityManager em = this.emf.createEntityManager();
        try {
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery();
            Root root = cq.from(this.configuration.entityClass());
            Type idType = root.getModel().getIdType();
            SingularAttribute idAttr = root.getModel().getId(idType.getJavaType());
            cq.select((Selection)root.get(idAttr));
            for (final Object key : em.createQuery(cq).getResultList()) {
                if (taskContext.isStopped()) break;
                if (filter != null && !filter.shouldLoadKey(key)) {
                    if (!trace) continue;
                    log.trace((Object)("Key " + key + " filtered"));
                    continue;
                }
                EntityTransaction txn = em.getTransaction();
                Object tempEntity = null;
                InternalMetadata tempMetadata = null;
                boolean loaded = false;
                txn.begin();
                try {
                    do {
                        try {
                            tempEntity = fetchValue ? em.find(this.configuration.entityClass(), key) : null;
                            tempMetadata = fetchMetadata ? this.getMetadata(em, key) : null;
                        }
                        finally {
                            try {
                                txn.commit();
                                loaded = true;
                            }
                            catch (Exception e) {
                                log.trace((Object)"Failed to load once", (Throwable)e);
                            }
                        }
                    } while (!loaded);
                }
                finally {
                    if (txn != null && txn.isActive()) {
                        txn.rollback();
                    }
                }
                final Object entity = tempEntity;
                final InternalMetadata metadata = tempMetadata;
                if (trace) {
                    log.trace((Object)("Processing " + key + " -> " + entity + "(" + metadata + ")"));
                }
                if (metadata != null && metadata.isExpired(this.timeService.wallClockTime())) continue;
                eacs.submit((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            MarshalledEntry marshalledEntry = JpaStore.this.marshallerEntryFactory.newMarshalledEntry(key, entity, metadata);
                            if (marshalledEntry != null) {
                                task.processEntry(marshalledEntry, (AdvancedCacheLoader.TaskContext)taskContext);
                            }
                            return null;
                        }
                        catch (Exception e) {
                            log.errorExecutingParallelStoreTask((Throwable)e);
                            throw e;
                        }
                    }
                });
            }
            eacs.waitUntilAllCompleted();
            if (eacs.isExceptionThrown()) {
                throw new PersistenceException("Execution exception!", (Throwable)eacs.getFirstException());
            }
        }
        finally {
            em.close();
        }
    }

    private InternalMetadata getMetadata(EntityManager em, Object key) {
        byte[] keyBytes;
        try {
            keyBytes = this.marshaller.objectToByteBuffer(key);
        }
        catch (Exception e) {
            throw new JpaStoreException("Failed to marshall key", e);
        }
        MetadataEntity m = (MetadataEntity)em.find(MetadataEntity.class, (Object)keyBytes);
        if (m == null) {
            return null;
        }
        try {
            return (InternalMetadata)this.marshaller.objectFromByteBuffer(m.getMetadata());
        }
        catch (Exception e) {
            throw new JpaStoreException("Failed to unmarshall metadata", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        EntityManager em = this.emf.createEntityManager();
        try {
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery cq = builder.createQuery(Long.class);
            cq.select((Selection)builder.count((Expression)cq.from(this.configuration.entityClass())));
            int n = ((Long)em.createQuery(cq).getSingleResult()).intValue();
            return n;
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(Executor threadPool, final AdvancedCacheWriter.PurgeListener listener) {
        ExecutorAllCompletionService eacs = new ExecutorAllCompletionService(threadPool);
        EntityManager em = this.emf.createEntityManager();
        try {
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(MetadataEntity.class);
            Root root = cq.from(MetadataEntity.class);
            long currentTime = this.timeService.wallClockTime();
            cq.where((Expression)cb.le((Expression)root.get("expiration"), (Number)currentTime));
            for (MetadataEntity metadata : em.createQuery(cq).getResultList()) {
                Object key;
                EntityTransaction txn = em.getTransaction();
                try {
                    key = this.marshaller.objectFromByteBuffer(metadata.name);
                }
                catch (Exception e) {
                    throw new JpaStoreException("Cannot unmarshall key", e);
                }
                long txnBegin = this.timeService.time();
                txn.begin();
                try {
                    long metadataFindBegin = this.timeService.time();
                    metadata = (MetadataEntity)em.find(MetadataEntity.class, (Object)metadata.name);
                    this.stats.addMetadataFind(this.timeService.time() - metadataFindBegin);
                    if (metadata.expiration > currentTime) {
                        txn.rollback();
                        continue;
                    }
                    long entityFindBegin = this.timeService.time();
                    Object entity = em.find(this.configuration.entityClass(), key);
                    this.stats.addEntityFind(this.timeService.time() - entityFindBegin);
                    if (entity != null) {
                        long entityRemoveBegin = this.timeService.time();
                        em.remove(entity);
                        this.stats.addEntityRemove(this.timeService.time() - entityRemoveBegin);
                    }
                    long metadataRemoveBegin = this.timeService.time();
                    em.remove((Object)metadata);
                    this.stats.addMetadataRemove(this.timeService.time() - metadataRemoveBegin);
                    txn.commit();
                    this.stats.addRemoveTxCommitted(this.timeService.time() - txnBegin);
                    if (trace) {
                        log.trace((Object)("Expired " + key + " -> " + entity + "(" + this.toString(metadata) + ")"));
                    }
                    if (listener == null) continue;
                    eacs.submit(new Runnable(){

                        @Override
                        public void run() {
                            listener.entryPurged(key);
                        }
                    }, null);
                }
                catch (RuntimeException e) {
                    this.stats.addRemoveTxFailed(this.timeService.time() - txnBegin);
                    throw e;
                }
                finally {
                    if (txn == null || !txn.isActive()) continue;
                    txn.rollback();
                }
            }
        }
        finally {
            em.close();
        }
        eacs.waitUntilAllCompleted();
        if (eacs.isExceptionThrown()) {
            throw new JpaStoreException(eacs.getFirstException());
        }
    }

    private String toString(MetadataEntity metadata) {
        if (metadata == null || !metadata.hasBytes()) {
            return "<no metadata>";
        }
        try {
            return this.marshaller.objectFromByteBuffer(metadata.getMetadata()).toString();
        }
        catch (Exception e) {
            log.trace((Object)"Failed to unmarshall metadata", (Throwable)e);
            return "<metadata: " + e + ">";
        }
    }
}

