/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;
import org.infinispan.commons.io.ByteBuffer;

@Entity
@Table(name="__ispn_metadata__")
class MetadataEntity {
    public static final String EXPIRATION = "expiration";
    @Id
    @Column(columnDefinition="VARBINARY(767)", length=767)
    public byte[] name;
    @Column(length=65535)
    public byte[] metadata;
    @Column(name="expiration")
    public long expiration;
    @Version
    public int version;

    public MetadataEntity() {
    }

    public MetadataEntity(ByteBuffer key, ByteBuffer metadata, long expiration) {
        this.name = key.getBuf();
        if (metadata != null) {
            this.metadata = metadata.getBuf();
        }
        this.expiration = expiration < 0L ? Long.MAX_VALUE : expiration;
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    public boolean hasBytes() {
        return this.metadata != null;
    }
}

