/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa;

import java.util.concurrent.atomic.AtomicLong;

public class Stats {
    private Operation entityFind = new Operation();
    private Operation entityMerge = new Operation();
    private Operation entityRemove = new Operation();
    private Operation metadataFind = new Operation();
    private Operation metadataMerge = new Operation();
    private Operation metadataRemove = new Operation();
    private Operation txReadCommitted = new Operation();
    private Operation txWriteCommitted = new Operation();
    private Operation txRemoveCommitted = new Operation();
    private Operation txReadFailed = new Operation();
    private Operation txWriteFailed = new Operation();
    private Operation txRemoveFailed = new Operation();

    public void addEntityMerge(long duration) {
        this.entityMerge.add(duration);
    }

    public void addMetadataMerge(long duration) {
        this.metadataMerge.add(duration);
    }

    public void addWriteTxCommited(long duration) {
        this.txWriteCommitted.add(duration);
    }

    public void addWriteTxFailed(long duration) {
        this.txWriteFailed.add(duration);
    }

    public void addEntityFind(long duration) {
        this.entityFind.add(duration);
    }

    public void addMetadataFind(long duration) {
        this.metadataFind.add(duration);
    }

    public void addReadTxCommitted(long duration) {
        this.txReadCommitted.add(duration);
    }

    public void addReadTxFailed(long duration) {
        this.txReadFailed.add(duration);
    }

    public void addEntityRemove(long duration) {
        this.entityRemove.add(duration);
    }

    public void addMetadataRemove(long duration) {
        this.metadataRemove.add(duration);
    }

    public void addRemoveTxCommitted(long duration) {
        this.txRemoveCommitted.add(duration);
    }

    public void addRemoveTxFailed(long duration) {
        this.txRemoveFailed.add(duration);
    }

    public String toString() {
        return "Stats{\nentityFind=" + this.entityFind + "\nentityMerge=" + this.entityMerge + "\nentityRemove=" + this.entityRemove + "\nmetadataFind=" + this.metadataFind + "\nmetadataMerge=" + this.metadataMerge + "\nmetadataRemove=" + this.metadataRemove + "\ntxReadCommitted=" + this.txReadCommitted + "\ntxReadFailed=" + this.txReadFailed + "\ntxWriteCommitted=" + this.txWriteCommitted + "\ntxWriteFailed=" + this.txWriteFailed + "\ntxRemoveCommitted=" + this.txRemoveCommitted + "\ntxRemoveFailed=" + this.txRemoveFailed + '}';
    }

    private class Operation {
        AtomicLong count = new AtomicLong();
        AtomicLong sum = new AtomicLong();

        private Operation() {
        }

        void add(long duration) {
            this.count.incrementAndGet();
            this.sum.addAndGet(duration);
        }

        public String toString() {
            long count = this.count.get();
            long sum = this.sum.get();
            return String.format("[count=%d, avg=%.2f ms]", count, count == 0L ? Double.NaN : (double)sum / (1000000.0 * (double)count));
        }
    }
}

