/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa;

import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.marshall.core.MarshalledEntryFactoryImpl;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.persistence.InitializationContextImpl;
import org.infinispan.persistence.jpa.JpaStore;
import org.infinispan.persistence.jpa.TestObject;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfigurationBuilder;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.util.DefaultTimeService;
import org.infinispan.util.TimeService;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractJpaStoreTest
extends AbstractInfinispanTest {
    protected static final String PERSISTENCE_UNIT_NAME = "org.infinispan.persistence.jpa";
    protected EmbeddedCacheManager cm;
    protected AdvancedLoadWriteStore cs;
    protected StreamingMarshaller marshaller;

    protected AbstractJpaStoreTest() {
    }

    protected EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createCacheManager((boolean)true);
    }

    protected AdvancedLoadWriteStore createCacheStore() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((JpaStoreConfigurationBuilder)builder.persistence().addStore(JpaStoreConfigurationBuilder.class)).persistenceUnitName(PERSISTENCE_UNIT_NAME).entityClass(this.getEntityClass());
        JpaStore store = new JpaStore();
        store.init((InitializationContext)new InitializationContextImpl((StoreConfiguration)((StoreConfigurationBuilder)builder.persistence().stores().get(0)).create(), this.cm.getCache(), this.getMarshaller(), (TimeService)new DefaultTimeService(), null, (MarshalledEntryFactory)new MarshalledEntryFactoryImpl(this.getMarshaller())));
        store.start();
        AssertJUnit.assertNotNull((Object)store.getEntityManagerFactory());
        Assert.assertTrue((boolean)(store.getEntityManagerFactory() instanceof HibernateEntityManagerFactory));
        return store;
    }

    protected abstract Class<?> getEntityClass();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        try {
            this.cm = this.createCacheManager();
            this.marshaller = this.cm.getCache().getAdvancedCache().getComponentRegistry().getCacheMarshaller();
            this.cs = this.createCacheStore();
            this.cs.clear();
        }
        catch (Exception e) {
            this.log.warn((Object)"Error during test setup", (Throwable)e);
            throw e;
        }
    }

    @AfterMethod(alwaysRun=true)
    public void stopMarshaller() {
        this.cs.stop();
        this.cm.stop();
    }

    protected StreamingMarshaller getMarshaller() {
        return this.marshaller;
    }

    protected MarshalledEntryImpl createEntry(Object key, Object value) {
        return new MarshalledEntryImpl(key, value, null, this.getMarshaller());
    }

    protected MarshalledEntryImpl createEntry(Object key, Object value, long lifespan) {
        InternalCacheEntry ice = TestInternalCacheEntryFactory.create((Object)key, (Object)value, (long)lifespan);
        return new MarshalledEntryImpl(key, value, (InternalMetadata)new InternalMetadataImpl(ice), this.getMarshaller());
    }

    protected MarshalledEntryImpl createEntry(TestObject obj) {
        return this.createEntry(obj.getKey(), obj.getValue());
    }
}

