/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa;

import io.reactivex.functions.Consumer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.infinispan.commons.util.concurrent.ConcurrentHashSet;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.persistence.jpa.AbstractJpaStoreTest;
import org.infinispan.persistence.jpa.TestObject;
import org.infinispan.persistence.spi.PersistenceException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.BaseJpaStoreTest")
public abstract class BaseJpaStoreTest
extends AbstractJpaStoreTest {
    protected abstract TestObject createTestObject(String var1);

    @Test(expectedExceptions={PersistenceException.class})
    public void testStoreNoJpa() {
        Assert.assertFalse((boolean)this.cs.contains((Object)"k"));
        this.cs.write((MarshalledEntry)this.createEntry("k", "v"));
    }

    @Test(expectedExceptions={PersistenceException.class})
    public void testStoreWithJpaBadKey() {
        Assert.assertFalse((boolean)this.cs.contains((Object)"k"));
        TestObject obj = this.createTestObject("1");
        this.cs.write((MarshalledEntry)this.createEntry("k", obj.getValue()));
    }

    public void testStoreWithJpaGoodKey() {
        TestObject obj = this.createTestObject("testStoreWithJpaGoodKey");
        Assert.assertFalse((boolean)this.cs.contains(obj.getKey()));
        MarshalledEntryImpl me = this.createEntry(obj);
        this.cs.write((MarshalledEntry)me);
    }

    public void testLoadAndStoreImmortal() {
        TestObject obj = this.createTestObject("testLoadAndStoreImmortal");
        Assert.assertFalse((boolean)this.cs.contains(obj.getKey()));
        MarshalledEntryImpl me = this.createEntry(obj);
        this.cs.write((MarshalledEntry)me);
        Assert.assertTrue((boolean)this.cs.contains(obj.getKey()));
        Assert.assertEquals((Object)obj.getValue(), (Object)this.cs.load(obj.getKey()).getValue());
        Assert.assertNull((Object)this.cs.load(obj.getKey()).getMetadata());
        boolean removed = this.cs.delete((Object)"nonExistentKey");
        Assert.assertFalse((boolean)removed);
    }

    public void testPreload() throws Exception {
        TestObject obj1 = this.createTestObject("testPreload1");
        TestObject obj2 = this.createTestObject("testPreload2");
        TestObject obj3 = this.createTestObject("testPreload3");
        this.cs.write((MarshalledEntry)this.createEntry(obj1));
        this.cs.write((MarshalledEntry)this.createEntry(obj2));
        this.cs.write((MarshalledEntry)this.createEntry(obj3));
        Assert.assertEquals((Object)this.cs.load(obj1.getKey()).getValue(), (Object)obj1.getValue());
        Assert.assertEquals((Object)this.cs.load(obj2.getKey()).getValue(), (Object)obj2.getValue());
        Assert.assertEquals((Object)this.cs.load(obj3.getKey()).getValue(), (Object)obj3.getValue());
        ConcurrentHashMap map = new ConcurrentHashMap();
        Consumer taskWithValues = me -> {
            if (me.getKey() != null && me.getValue() != null) {
                map.put(me.getKey(), me.getValue());
            }
        };
        this.cs.publishEntries(null, true, false).blockingSubscribe(taskWithValues);
        Assert.assertEquals((int)map.size(), (int)3);
        Assert.assertEquals(map.remove(obj1.getKey()), (Object)obj1.getValue());
        Assert.assertEquals(map.remove(obj2.getKey()), (Object)obj2.getValue());
        Assert.assertEquals(map.remove(obj3.getKey()), (Object)obj3.getValue());
        Assert.assertTrue((boolean)map.isEmpty());
        ConcurrentHashSet set = new ConcurrentHashSet();
        Consumer taskWithoutValues = me -> {
            if (me.getKey() != null) {
                set.add(me.getKey());
            }
        };
        this.cs.publishEntries(null, false, false).blockingSubscribe(taskWithoutValues);
        Assert.assertEquals((int)set.size(), (int)3);
        Assert.assertTrue((boolean)set.remove(obj1.getKey()));
        Assert.assertTrue((boolean)set.remove(obj2.getKey()));
        Assert.assertTrue((boolean)set.remove(obj3.getKey()));
        Assert.assertTrue((boolean)set.isEmpty());
        Set collectSet = (Set)this.cs.publishKeys(null).collectInto(new HashSet(), Set::add).blockingGet();
        Assert.assertEquals((int)collectSet.size(), (int)3);
        Assert.assertTrue((boolean)collectSet.remove(obj1.getKey()));
        Assert.assertTrue((boolean)collectSet.remove(obj2.getKey()));
        Assert.assertTrue((boolean)collectSet.remove(obj3.getKey()));
        Assert.assertTrue((boolean)collectSet.isEmpty());
    }

    public void testStoreAndRemoveAll() {
        TestObject obj1 = this.createTestObject("testStoreAndRemoveAll1");
        TestObject obj2 = this.createTestObject("testStoreAndRemoveAll2");
        TestObject obj3 = this.createTestObject("testStoreAndRemoveAll3");
        TestObject obj4 = this.createTestObject("testStoreAndRemoveAll4");
        this.cs.write((MarshalledEntry)this.createEntry(obj1));
        this.cs.write((MarshalledEntry)this.createEntry(obj2));
        this.cs.write((MarshalledEntry)this.createEntry(obj3));
        this.cs.write((MarshalledEntry)this.createEntry(obj4));
        Assert.assertEquals((int)this.cs.size(), (int)4);
        this.cs.clear();
        Assert.assertEquals((int)this.cs.size(), (int)0);
        Assert.assertFalse((boolean)this.cs.contains(obj1.getKey()));
        Assert.assertFalse((boolean)this.cs.contains(obj2.getKey()));
        Assert.assertFalse((boolean)this.cs.contains(obj3.getKey()));
        Assert.assertFalse((boolean)this.cs.contains(obj4.getKey()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStoreValuesViaNonJpaCacheStore() {
        TestObject obj1 = this.createTestObject("testStoreViaNonJpaCacheStore1");
        TestObject obj2 = this.createTestObject("testStoreViaNonJpaCacheStore2");
        Assert.assertEquals((int)this.cs.size(), (int)0);
        Assert.assertFalse((boolean)this.cs.contains(obj1.getKey()));
        Assert.assertFalse((boolean)this.cs.contains(obj1.getKey()));
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.infinispan.persistence.jpa");
        EntityManager em = emf.createEntityManager();
        try {
            EntityTransaction txn = em.getTransaction();
            txn.begin();
            em.persist(obj1.getValue());
            em.persist(obj2.getValue());
            em.flush();
            txn.commit();
            Assert.assertEquals((int)this.cs.size(), (int)2);
            Assert.assertTrue((boolean)this.cs.contains(obj1.getKey()));
            Assert.assertTrue((boolean)this.cs.contains(obj1.getKey()));
        }
        finally {
            em.close();
            emf.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadValuesViaNonJpaCacheStore() {
        TestObject obj1 = this.createTestObject("testLoadViaNonJpaCacheStore1");
        TestObject obj2 = this.createTestObject("testLoadViaNonJpaCacheStore2");
        this.cs.write((MarshalledEntry)this.createEntry(obj1));
        this.cs.write((MarshalledEntry)this.createEntry(obj2));
        Assert.assertEquals((int)this.cs.size(), (int)2);
        Assert.assertTrue((boolean)this.cs.contains(obj1.getKey()));
        Assert.assertTrue((boolean)this.cs.contains(obj1.getKey()));
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.infinispan.persistence.jpa");
        EntityManager em = emf.createEntityManager();
        try {
            Assert.assertEquals((Object)em.find(obj1.getValue().getClass(), obj1.getKey()), (Object)obj1.getValue());
            Assert.assertEquals((Object)em.find(obj2.getValue().getClass(), obj2.getKey()), (Object)obj2.getValue());
        }
        finally {
            em.close();
            emf.close();
        }
    }
}

