/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.leveldb.configuration;

import org.infinispan.configuration.BuiltBy;
import org.infinispan.configuration.cache.AbstractLockSupportStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.cache.LegacyLoaderAdapter;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.leveldb.LevelDBCacheStoreConfig;
import org.infinispan.loaders.leveldb.configuration.LevelDBCacheStoreConfigurationBuilder;
import org.infinispan.util.TypedProperties;
import org.iq80.leveldb.CompressionType;

@BuiltBy(value=LevelDBCacheStoreConfigurationBuilder.class)
public class LevelDBCacheStoreConfiguration
extends AbstractLockSupportStoreConfiguration
implements LegacyLoaderAdapter<LevelDBCacheStoreConfig> {
    private final String location;
    private final String expiredLocation;
    private final CompressionType compressionType;
    private final Integer blockSize;
    private final Long cacheSize;
    private final int expiryQueueSize;
    private final int clearThreshold;

    protected LevelDBCacheStoreConfiguration(String location, String expiredLocation, CompressionType compressionType, Integer blockSize, Long cacheSize, int expiryQueueSize, int clearThreshold, long lockAcquistionTimeout, int lockConcurrencyLevel, boolean purgeOnStartup, boolean purgeSynchronously, int purgerThreads, boolean fetchPersistentState, boolean ignoreModifications, TypedProperties properties, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        super(lockAcquistionTimeout, lockConcurrencyLevel, purgeOnStartup, purgeSynchronously, purgerThreads, fetchPersistentState, ignoreModifications, properties, async, singletonStore);
        this.location = location;
        this.expiredLocation = expiredLocation;
        this.compressionType = compressionType;
        this.blockSize = blockSize;
        this.cacheSize = cacheSize;
        this.expiryQueueSize = expiryQueueSize;
        this.clearThreshold = clearThreshold;
    }

    public LevelDBCacheStoreConfig adapt() {
        LevelDBCacheStoreConfig config = new LevelDBCacheStoreConfig();
        LegacyConfigurationAdaptor.adapt((CacheStoreConfiguration)this, (CacheStoreConfig)config);
        config.setLocation(this.location);
        config.setExpiredLocation(this.expiredLocation);
        config.setCompressionType(this.compressionType.toString());
        config.setBlockSize(this.blockSize);
        config.setCacheSize(this.cacheSize);
        config.setExpiryQueueSize(this.expiryQueueSize);
        config.setClearThreshold(this.clearThreshold);
        return config;
    }

    public String location() {
        return this.location;
    }

    public String expiredLocation() {
        return this.expiredLocation;
    }

    public CompressionType compressionType() {
        return this.compressionType;
    }

    public Integer blockSize() {
        return this.blockSize;
    }

    public Long cacheSize() {
        return this.cacheSize;
    }

    public int expiryQueueSize() {
        return this.expiryQueueSize;
    }

    public int clearThreshold() {
        return this.clearThreshold;
    }
}

