/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.leveldb.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser52;
import org.infinispan.loaders.leveldb.configuration.Attribute;
import org.infinispan.loaders.leveldb.configuration.Element;
import org.infinispan.loaders.leveldb.configuration.LevelDBCacheStoreConfigurationBuilder;
import org.infinispan.util.StringPropertyReplacer;
import org.iq80.leveldb.CompressionType;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class LevelDBCacheStoreConfigurationParser52
implements ConfigurationParser<ConfigurationBuilderHolder> {
    public Namespace[] getSupportedNamespaces() {
        return new Namespace[]{new Namespace("urn:infinispan:config", "leveldb", Element.LEVELDB_STORE.getLocalName(), 5, 2), new Namespace("", Element.LEVELDB_STORE.getLocalName(), 0, 0)};
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case LEVELDB_STORE: {
                this.parseLevelDBCacheStore(reader, (LevelDBCacheStoreConfigurationBuilder)builder.loaders().addLoader(LevelDBCacheStoreConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseLevelDBCacheStore(XMLExtendedStreamReader reader, LevelDBCacheStoreConfigurationBuilder builder) throws XMLStreamException {
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case LOCATION: {
                    builder.location(value);
                    continue block9;
                }
                case EXPIRED_LOCATION: {
                    builder.expiredLocation(value);
                    continue block9;
                }
                case CLEAR_THRESHOLD: {
                    builder.clearThreshold(Integer.valueOf(value));
                    continue block9;
                }
                case EXPIRY_QUEUE_SIZE: {
                    builder.expiryQueueSize(Integer.valueOf(value));
                }
                case BLOCK_SIZE: {
                    builder.blockSize(Integer.valueOf(value));
                    continue block9;
                }
                case CACHE_SIZE: {
                    builder.cacheSize(Long.valueOf(value));
                    continue block9;
                }
                case COMPRESSION_TYPE: {
                    builder.compressionType(CompressionType.valueOf((String)value));
                    continue block9;
                }
                default: {
                    Parser52.parseCommonStoreAttributes((XMLExtendedStreamReader)reader, (int)i, (CacheStoreConfigurationBuilder)builder);
                }
            }
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }
}

