/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.leveldb.configuration;

import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractLockSupportStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.loaders.leveldb.LevelDBCacheStoreConfig;
import org.infinispan.loaders.leveldb.configuration.LevelDBCacheStoreConfiguration;
import org.iq80.leveldb.CompressionType;

public class LevelDBCacheStoreConfigurationBuilder
extends AbstractLockSupportStoreConfigurationBuilder<LevelDBCacheStoreConfiguration, LevelDBCacheStoreConfigurationBuilder> {
    protected String location = "leveldb/data";
    protected String expiredLocation = "leveldb/expired";
    protected CompressionType compressionType = LevelDBCacheStoreConfig.DEFAULT_COMPRESSION_TYPE;
    protected LevelDBCacheStoreConfig.ImplementationType implementationType = LevelDBCacheStoreConfig.DEFAULT_IMPLEMENTATION_TYPE;
    protected Integer blockSize;
    protected Long cacheSize;
    protected int expiryQueueSize = 10000;
    protected int clearThreshold = 10000;

    public LevelDBCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    public LevelDBCacheStoreConfigurationBuilder location(String location) {
        this.location = location;
        return this.self();
    }

    public LevelDBCacheStoreConfigurationBuilder expiredLocation(String expiredLocation) {
        this.expiredLocation = expiredLocation;
        return this.self();
    }

    public LevelDBCacheStoreConfigurationBuilder implementationType(LevelDBCacheStoreConfig.ImplementationType implementationType) {
        this.implementationType = implementationType;
        return this.self();
    }

    public LevelDBCacheStoreConfigurationBuilder blockSize(int blockSize) {
        this.blockSize = blockSize;
        return this.self();
    }

    public LevelDBCacheStoreConfigurationBuilder cacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
        return this.self();
    }

    public LevelDBCacheStoreConfigurationBuilder expiryQueueSize(int expiryQueueSize) {
        this.expiryQueueSize = expiryQueueSize;
        return this.self();
    }

    public LevelDBCacheStoreConfigurationBuilder clearThreshold(int clearThreshold) {
        this.clearThreshold = clearThreshold;
        return this.self();
    }

    public LevelDBCacheStoreConfigurationBuilder compressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
        return this.self();
    }

    public void validate() {
        super.validate();
    }

    public LevelDBCacheStoreConfiguration create() {
        return new LevelDBCacheStoreConfiguration(this.location, this.expiredLocation, this.implementationType, this.compressionType, this.blockSize, this.cacheSize, this.expiryQueueSize, this.clearThreshold, this.lockAcquistionTimeout, this.lockConcurrencyLevel, this.purgeOnStartup, this.purgeSynchronously, this.purgerThreads, this.fetchPersistentState, this.ignoreModifications, TypedProperties.toTypedProperties((Properties)this.properties), this.async.create(), this.singletonStore.create());
    }

    public Builder<?> read(LevelDBCacheStoreConfiguration template) {
        this.location = template.location();
        this.expiredLocation = template.expiredLocation();
        this.implementationType = template.implementationType();
        this.compressionType = template.compressionType();
        this.blockSize = template.blockSize();
        this.cacheSize = template.cacheSize();
        this.expiryQueueSize = template.expiryQueueSize();
        this.clearThreshold = template.clearThreshold();
        this.lockAcquistionTimeout = template.lockAcquistionTimeout();
        this.lockConcurrencyLevel = template.lockConcurrencyLevel();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.purgeSynchronously = template.purgeSynchronously();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return this.self();
    }

    public LevelDBCacheStoreConfigurationBuilder self() {
        return this;
    }
}

