/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.leveldb.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    LOCATION("location"),
    EXPIRED_LOCATION("expiredLocation"),
    IMPLEMENTATION_TYPE("implementationType"),
    CLEAR_THRESHOLD("clearThreshold"),
    EXPIRY_QUEUE_SIZE("expiryQueueSize"),
    COMPRESSION_TYPE("compressionType"),
    BLOCK_SIZE("blockSize"),
    CACHE_SIZE("cacheSize");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

