/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.leveldb.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser60;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.leveldb.configuration.Attribute;
import org.infinispan.persistence.leveldb.configuration.CompressionType;
import org.infinispan.persistence.leveldb.configuration.Element;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfiguration;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfigurationBuilder;

@Namespaces(value={@Namespace(uri="urn:infinispan:config:store:leveldb:6.0", root="leveldbStore"), @Namespace(root="leveldbStore")})
public class LevelDBStoreConfigurationParser60
implements ConfigurationParser {
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case LEVELDB_STORE: {
                this.parseLevelDBCacheStore(reader, (LevelDBStoreConfigurationBuilder)builder.persistence().addStore(LevelDBStoreConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseLevelDBCacheStore(XMLExtendedStreamReader reader, LevelDBStoreConfigurationBuilder builder) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String attributeValue = reader.getAttributeValue(i);
            String value = StringPropertyReplacer.replaceProperties((String)attributeValue);
            String attrName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case LOCATION: {
                    builder.location(value);
                    continue block10;
                }
                case EXPIRED_LOCATION: {
                    builder.expiredLocation(value);
                    continue block10;
                }
                case IMPLEMENTATION_TYPE: {
                    builder.implementationType(LevelDBStoreConfiguration.ImplementationType.valueOf(value));
                    continue block10;
                }
                case CLEAR_THRESHOLD: {
                    builder.clearThreshold(Integer.valueOf(value));
                    continue block10;
                }
                case EXPIRY_QUEUE_SIZE: {
                    builder.expiryQueueSize(Integer.valueOf(value));
                }
                case BLOCK_SIZE: {
                    builder.blockSize(Integer.valueOf(value));
                    continue block10;
                }
                case CACHE_SIZE: {
                    builder.cacheSize(Long.valueOf(value));
                    continue block10;
                }
                case COMPRESSION_TYPE: {
                    builder.compressionType(CompressionType.valueOf(value));
                    continue block10;
                }
                default: {
                    Parser60.parseCommonStoreAttributes((XMLExtendedStreamReader)reader, (StoreConfigurationBuilder)builder, (String)attrName, (String)attributeValue, (int)i);
                }
            }
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }
}

