/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.leveldb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.util.Util;
import org.infinispan.executors.ExecutorAllCompletionService;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfiguration;
import org.infinispan.persistence.leveldb.logging.Log;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.DBFactory;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;

@ConfiguredBy(value=LevelDBStoreConfiguration.class)
public class LevelDBStore
implements AdvancedLoadWriteStore {
    private static final Log log = (Log)LogFactory.getLog(LevelDBStore.class, Log.class);
    private static final String JNI_DB_FACTORY_CLASS_NAME = "org.fusesource.leveldbjni.JniDBFactory";
    private static final String JAVA_DB_FACTORY_CLASS_NAME = "org.iq80.leveldb.impl.Iq80DBFactory";
    private static final String[] DB_FACTORY_CLASS_NAMES = new String[]{"org.fusesource.leveldbjni.JniDBFactory", "org.iq80.leveldb.impl.Iq80DBFactory"};
    private LevelDBStoreConfiguration configuration;
    private BlockingQueue<ExpiryEntry> expiryEntryQueue;
    private DBFactory dbFactory;
    private DB db;
    private DB expiredDb;
    private InitializationContext ctx;

    public void init(InitializationContext ctx) {
        this.configuration = (LevelDBStoreConfiguration)ctx.getConfiguration();
        this.dbFactory = this.newDbFactory();
        this.ctx = ctx;
        if (this.dbFactory == null) {
            throw log.cannotLoadlevelDBFactories(Arrays.toString(DB_FACTORY_CLASS_NAMES));
        }
        String dbFactoryClassName = this.dbFactory.getClass().getName();
        if (dbFactoryClassName.equals(JAVA_DB_FACTORY_CLASS_NAME)) {
            log.infoUsingJavaDbFactory(dbFactoryClassName);
        } else {
            log.infoUsingJNIDbFactory(dbFactoryClassName);
        }
    }

    protected DBFactory newDbFactory() {
        switch (this.configuration.implementationType()) {
            case JNI: {
                return (DBFactory)Util.getInstance((String)JNI_DB_FACTORY_CLASS_NAME, (ClassLoader)LevelDBStore.class.getClassLoader());
            }
            case JAVA: {
                return (DBFactory)Util.getInstance((String)JAVA_DB_FACTORY_CLASS_NAME, (ClassLoader)LevelDBStore.class.getClassLoader());
            }
        }
        for (String className : DB_FACTORY_CLASS_NAMES) {
            try {
                return (DBFactory)Util.getInstance((String)className, (ClassLoader)LevelDBStore.class.getClassLoader());
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) continue;
                log.debugUnableToInstantiateDbFactory(className, e);
            }
        }
        return null;
    }

    public void start() {
        this.expiryEntryQueue = new LinkedBlockingQueue<ExpiryEntry>(this.configuration.expiryQueueSize());
        try {
            this.db = this.openDatabase(this.getQualifiedLocation(), this.dataDbOptions());
            this.expiredDb = this.openDatabase(this.getQualifiedExpiredLocation(), this.expiredDbOptions());
        }
        catch (IOException e) {
            throw new CacheConfigurationException("Unable to open database", (Throwable)e);
        }
    }

    private String sanitizedCacheName() {
        String cacheFileName = this.ctx.getCache().getName().replaceAll("[^a-zA-Z0-9-_\\.]", "_");
        return cacheFileName;
    }

    private String getQualifiedLocation() {
        return this.configuration.location() + this.sanitizedCacheName();
    }

    private String getQualifiedExpiredLocation() {
        return this.configuration.expiredLocation() + this.sanitizedCacheName();
    }

    private Options dataDbOptions() {
        Options options = new Options().createIfMissing(true);
        options.compressionType(CompressionType.valueOf((String)this.configuration.compressionType().name()));
        if (this.configuration.blockSize() != null) {
            options.blockSize(this.configuration.blockSize().intValue());
        }
        if (this.configuration.cacheSize() != null) {
            options.cacheSize(this.configuration.cacheSize().longValue());
        }
        return options;
    }

    private Options expiredDbOptions() {
        return new Options().createIfMissing(true);
    }

    protected DB openDatabase(String location, Options options) throws IOException {
        File dir = new File(location);
        dir.mkdirs();
        return this.dbFactory.open(dir, options);
    }

    protected void destroyDatabase(String location) throws IOException {
        File dir = new File(location);
        this.dbFactory.destroy(dir, new Options());
    }

    protected DB reinitDatabase(String location, Options options) throws IOException {
        this.destroyDatabase(location);
        return this.openDatabase(location, options);
    }

    protected void reinitAllDatabases() throws IOException {
        try {
            this.db.close();
        }
        catch (IOException e) {
            log.warnUnableToCloseDb(e);
        }
        try {
            this.expiredDb.close();
        }
        catch (IOException e) {
            log.warnUnableToCloseExpiredDb(e);
        }
        this.db = this.reinitDatabase(this.getQualifiedLocation(), this.dataDbOptions());
        this.expiredDb = this.reinitDatabase(this.getQualifiedExpiredLocation(), this.expiredDbOptions());
    }

    public void stop() {
        try {
            this.db.close();
        }
        catch (IOException e) {
            log.warnUnableToCloseDb(e);
        }
        try {
            this.expiredDb.close();
        }
        catch (IOException e) {
            log.warnUnableToCloseExpiredDb(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        long count = 0L;
        DBIterator it = this.db.iterator(new ReadOptions().fillCache(false));
        boolean destroyDatabase = false;
        if (this.configuration.clearThreshold() <= 0) {
            try {
                it.seekToFirst();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    this.db.delete((byte[])entry.getKey());
                    if (++count <= (long)this.configuration.clearThreshold()) continue;
                    destroyDatabase = true;
                }
            }
            finally {
                try {
                    it.close();
                }
                catch (IOException e) {
                    log.warnUnableToCloseDbIterator(e);
                }
            }
        } else {
            destroyDatabase = true;
        }
        if (destroyDatabase) {
            try {
                this.reinitAllDatabases();
            }
            catch (IOException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
    }

    public int size() {
        return PersistenceUtil.count((AdvancedCacheLoader)this, null);
    }

    public boolean contains(Object key) {
        try {
            return this.load(key) != null;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void process(AdvancedCacheLoader.KeyFilter keyFilter, AdvancedCacheLoader.CacheLoaderTask cacheLoaderTask, Executor executor, boolean loadValues, boolean loadMetadata) {
        int batchSize = 100;
        ExecutorAllCompletionService eacs = new ExecutorAllCompletionService(executor);
        TaskContextImpl taskContext = new TaskContextImpl();
        ArrayList<Map.Entry<Object, Object>> entries = new ArrayList<Map.Entry<byte[], byte[]>>(batchSize);
        DBIterator it = this.db.iterator(new ReadOptions().fillCache(false));
        try {
            it.seekToFirst();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                entries.add(entry);
                if (entries.size() != batchSize) continue;
                ArrayList<Map.Entry<byte[], byte[]>> batch = entries;
                entries = new ArrayList(batchSize);
                this.submitProcessTask(cacheLoaderTask, keyFilter, (CompletionService)eacs, (AdvancedCacheLoader.TaskContext)taskContext, batch);
            }
            if (!entries.isEmpty()) {
                this.submitProcessTask(cacheLoaderTask, keyFilter, (CompletionService)eacs, (AdvancedCacheLoader.TaskContext)taskContext, entries);
            }
            eacs.waitUntilAllCompleted();
            if (eacs.isExceptionThrown()) {
                throw new PersistenceException("Execution exception!", (Throwable)eacs.getFirstException());
            }
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        finally {
            try {
                it.close();
            }
            catch (IOException e) {
                log.warnUnableToCloseDbIterator(e);
            }
        }
    }

    private void submitProcessTask(final AdvancedCacheLoader.CacheLoaderTask cacheLoaderTask, final AdvancedCacheLoader.KeyFilter filter, CompletionService ecs, final AdvancedCacheLoader.TaskContext taskContext, final List<Map.Entry<byte[], byte[]>> batch) {
        ecs.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    long now = LevelDBStore.this.ctx.getTimeService().wallClockTime();
                    for (Map.Entry entry : batch) {
                        if (!taskContext.isStopped()) {
                            MarshalledEntry unmarshall;
                            boolean isExpired;
                            Object key = LevelDBStore.this.unmarshall((byte[])entry.getKey());
                            if (filter != null && !filter.shouldLoadKey(key) || (isExpired = (unmarshall = (MarshalledEntry)LevelDBStore.this.unmarshall((byte[])entry.getValue())).getMetadata() != null && unmarshall.getMetadata().isExpired(now))) continue;
                            cacheLoaderTask.processEntry(unmarshall, taskContext);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    log.errorExecutingParallelStoreTask(e);
                    throw e;
                }
                return null;
            }
        });
    }

    public boolean delete(Object key) {
        try {
            byte[] keyBytes = this.marshall(key);
            if (this.db.get(keyBytes) == null) {
                return false;
            }
            this.db.delete(keyBytes);
            return true;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void write(MarshalledEntry me) {
        try {
            this.db.put(this.marshall(me.getKey()), this.marshall(me));
            InternalMetadata meta = me.getMetadata();
            if (meta != null && meta.expiryTime() > -1L) {
                this.addNewExpiry(me);
            }
        }
        catch (Exception e) {
            throw new DBException((Throwable)e);
        }
    }

    public MarshalledEntry load(Object key) {
        try {
            MarshalledEntry me = (MarshalledEntry)this.unmarshall(this.db.get(this.marshall(key)));
            if (me == null) {
                return null;
            }
            InternalMetadata meta = me.getMetadata();
            if (meta != null && meta.isExpired(this.ctx.getTimeService().wallClockTime())) {
                return null;
            }
            return me;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener purgeListener) {
        try {
            ArrayList entries = new ArrayList();
            this.expiryEntryQueue.drainTo(entries);
            for (ExpiryEntry entry : entries) {
                byte[] expiryBytes = this.marshall(entry.expiry);
                byte[] keyBytes = this.marshall(entry.key);
                byte[] existingBytes = this.expiredDb.get(expiryBytes);
                if (existingBytes != null) {
                    Object existing = this.unmarshall(existingBytes);
                    if (existing instanceof List) {
                        ((List)existing).add(entry.key);
                        this.expiredDb.put(expiryBytes, this.marshall(existing));
                        continue;
                    }
                    ArrayList<Object> al = new ArrayList<Object>(2);
                    al.add(existing);
                    al.add(entry.key);
                    this.expiredDb.put(expiryBytes, this.marshall(al));
                    continue;
                }
                this.expiredDb.put(expiryBytes, keyBytes);
            }
            ArrayList<Long> times = new ArrayList<Long>();
            ArrayList<Object> keys = new ArrayList<Object>();
            DBIterator it = this.expiredDb.iterator(new ReadOptions().fillCache(false));
            try {
                Map.Entry entry;
                Long time;
                it.seekToFirst();
                while (it.hasNext() && (time = (Long)this.unmarshall((byte[])(entry = (Map.Entry)it.next()).getKey())) <= System.currentTimeMillis()) {
                    times.add(time);
                    Object key = this.unmarshall((byte[])entry.getValue());
                    if (key instanceof List) {
                        keys.addAll((List)key);
                        continue;
                    }
                    keys.add(key);
                }
                for (Long time2 : times) {
                    this.expiredDb.delete(this.marshall(time2));
                }
                if (!keys.isEmpty()) {
                    log.debugf("purge (up to) %d entries", keys.size());
                }
                int count = 0;
                long currentTimeMillis = System.currentTimeMillis();
                for (Object e : keys) {
                    MarshalledEntry me;
                    byte[] keyBytes = this.marshall(e);
                    byte[] b = this.db.get(keyBytes);
                    if (b == null || (me = (MarshalledEntry)this.ctx.getMarshaller().objectFromByteBuffer(b)).getMetadata() == null || !me.getMetadata().isExpired(this.ctx.getTimeService().wallClockTime())) continue;
                    this.db.delete(keyBytes);
                    ++count;
                }
                if (count != 0) {
                    log.debugf("purged %d entries", count);
                }
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
            finally {
                try {
                    it.close();
                }
                catch (IOException e) {
                    log.warnUnableToCloseDbIterator(e);
                }
            }
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private byte[] marshall(Object entry) throws IOException, InterruptedException {
        return this.ctx.getMarshaller().objectToByteBuffer(entry);
    }

    private Object unmarshall(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        return this.ctx.getMarshaller().objectFromByteBuffer(bytes);
    }

    private void addNewExpiry(MarshalledEntry entry) throws IOException {
        long expiry = entry.getMetadata().expiryTime();
        long maxIdle = entry.getMetadata().maxIdle();
        if (maxIdle > 0L) {
            expiry = maxIdle + System.currentTimeMillis();
        }
        Long at = expiry;
        Object key = entry.getKey();
        try {
            this.expiryEntryQueue.put(new ExpiryEntry(at, key));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static final class ExpiryEntry {
        private final Long expiry;
        private final Object key;

        private ExpiryEntry(long expiry, Object key) {
            this.expiry = expiry;
            this.key = key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpiryEntry other = (ExpiryEntry)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }
}

