/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.leveldb.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;
import org.infinispan.persistence.leveldb.configuration.Attribute;
import org.infinispan.persistence.leveldb.configuration.Element;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfiguration;

public class LevelDBStoreConfigurationSerializer
extends AbstractStoreSerializer
implements ConfigurationSerializer<LevelDBStoreConfiguration> {
    public void serialize(XMLExtendedStreamWriter writer, LevelDBStoreConfiguration configuration) throws XMLStreamException {
        AttributeSet attributes = configuration.attributes();
        writer.writeStartElement((Enum)Element.LEVELDB_STORE);
        configuration.attributes().write((XMLStreamWriter)writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        if (attributes.attribute(LevelDBStoreConfiguration.COMPRESSION_TYPE).isModified()) {
            writer.writeStartElement((Enum)Element.COMPRESSION);
            attributes.write((XMLStreamWriter)writer, LevelDBStoreConfiguration.COMPRESSION_TYPE, (Enum)Attribute.TYPE);
            writer.writeEndElement();
        }
        if (attributes.attribute(LevelDBStoreConfiguration.EXPIRED_LOCATION).isModified() || attributes.attribute(LevelDBStoreConfiguration.EXPIRY_QUEUE_SIZE).isModified()) {
            writer.writeStartElement((Enum)Element.EXPIRATION);
            attributes.write((XMLStreamWriter)writer, LevelDBStoreConfiguration.EXPIRED_LOCATION, (Enum)Attribute.PATH);
            attributes.write((XMLStreamWriter)writer, LevelDBStoreConfiguration.EXPIRY_QUEUE_SIZE, (Enum)Attribute.QUEUE_SIZE);
            writer.writeEndElement();
        }
        if (attributes.attribute(LevelDBStoreConfiguration.IMPLEMENTATION_TYPE).isModified()) {
            writer.writeStartElement((Enum)Element.IMPLEMENTATION);
            attributes.write((XMLStreamWriter)writer, LevelDBStoreConfiguration.IMPLEMENTATION_TYPE, (Enum)Attribute.TYPE);
            writer.writeEndElement();
        }
        this.writeCommonStoreElements(writer, (StoreConfiguration)configuration);
        writer.writeEndElement();
    }
}

