/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.redis;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.redis.client.RedisConnection;
import org.infinispan.persistence.redis.client.RedisConnectionPool;
import org.infinispan.persistence.redis.client.RedisConnectionPoolFactory;
import org.infinispan.persistence.redis.configuration.RedisStoreConfiguration;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
@ConfiguredBy(value=RedisStoreConfiguration.class)
public final class RedisStore
implements AdvancedLoadWriteStore {
    private static final Log log = (Log)LogFactory.getLog(RedisStore.class, Log.class);
    private InitializationContext ctx = null;
    private RedisConnectionPool connectionPool = null;

    public void init(InitializationContext ctx) {
        log.info((Object)"Redis cache store initialising");
        this.ctx = ctx;
    }

    public void start() {
        log.info((Object)"Redis cache store starting");
        try {
            this.connectionPool = RedisConnectionPoolFactory.factory((RedisStoreConfiguration)this.ctx.getConfiguration(), this.ctx.getMarshaller());
        }
        catch (Exception ex) {
            log.error((Object)"Failed to initialise the redis store", (Throwable)ex);
            throw new PersistenceException((Throwable)ex);
        }
    }

    public void stop() {
        log.info((Object)"Redis cache store stopping");
        if (null != this.connectionPool) {
            this.connectionPool.shutdown();
        }
    }

    public void process(KeyFilter filter, final AdvancedCacheLoader.CacheLoaderTask task, Executor executor, final boolean fetchValue, boolean fetchMetadata) {
        log.debug((Object)"Iterating Redis store entries");
        final InitializationContext ctx = this.ctx;
        TaskContextImpl taskContext = new TaskContextImpl();
        RedisConnectionPool connectionPool = this.connectionPool;
        final RedisStore cacheStore = this;
        RedisConnection connection = connectionPool.getConnection();
        try {
            for (final Object key : connection.scan()) {
                if (taskContext.isStopped()) {
                    break;
                }
                if (null != filter && !filter.accept(key)) continue;
                executor.execute(new Runnable((AdvancedCacheLoader.TaskContext)taskContext){
                    final /* synthetic */ AdvancedCacheLoader.TaskContext val$taskContext;
                    {
                        this.val$taskContext = taskContext;
                    }

                    @Override
                    public void run() {
                        try {
                            MarshalledEntry marshalledEntry = fetchValue ? cacheStore.load(key) : ctx.getMarshalledEntryFactory().newMarshalledEntry(key, null, (ByteBuffer)null);
                            if (null != marshalledEntry) {
                                task.processEntry(marshalledEntry, this.val$taskContext);
                            }
                        }
                        catch (Exception ex) {
                            log.error((Object)"Failed to process the redis store key", (Throwable)ex);
                            throw new PersistenceException((Throwable)ex);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            log.error((Object)"Failed to process the redis store keys", (Throwable)ex);
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            if (null != connection) {
                connection.release();
            }
        }
    }

    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener purgeListener) {
    }

    public int size() {
        log.debug((Object)"Calculating Redis store size");
        RedisConnection connection = null;
        try {
            connection = this.connectionPool.getConnection();
            long dbSize = connection.dbSize();
            if (dbSize > Integer.MAX_VALUE) {
                log.info((Object)String.format("Redis store is holding more elements than we can count! Total number of elements found %d. Limited to returning count as %d", dbSize, Integer.MAX_VALUE));
                int n = Integer.MAX_VALUE;
                return n;
            }
            int n = (int)dbSize;
            return n;
        }
        catch (Exception ex) {
            log.error((Object)"Failed to fetch element count from the redis store", (Throwable)ex);
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            if (null != connection) {
                connection.release();
            }
        }
    }

    public void clear() {
        log.debug((Object)"Clearing Redis store");
        RedisConnection connection = null;
        try {
            connection = this.connectionPool.getConnection();
            connection.flushDb();
        }
        catch (Exception ex) {
            log.error((Object)"Failed to clear all elements in the redis store", (Throwable)ex);
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            if (null != connection) {
                connection.release();
            }
        }
    }

    public MarshalledEntry load(Object key) {
        log.debug((Object)"Loading entry from Redis store");
        RedisConnection connection = null;
        try {
            connection = this.connectionPool.getConnection();
            List<byte[]> data = connection.hmget(key, "value", "metadata");
            byte[] value = data.get(0);
            if (null == value) {
                MarshalledEntry marshalledEntry = null;
                return marshalledEntry;
            }
            ByteBuffer valueBuf = this.ctx.getByteBufferFactory().newByteBuffer(value, 0, value.length);
            ByteBuffer metadataBuf = null;
            byte[] metadata = data.get(1);
            if (null != metadata) {
                metadataBuf = this.ctx.getByteBufferFactory().newByteBuffer(metadata, 0, metadata.length);
            }
            MarshalledEntry marshalledEntry = this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, valueBuf, metadataBuf);
            return marshalledEntry;
        }
        catch (Exception ex) {
            log.error((Object)"Failed to load element from the redis store", (Throwable)ex);
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            if (null != connection) {
                connection.release();
            }
        }
    }

    public void write(MarshalledEntry marshalledEntry) {
        log.debug((Object)"Writing entry to Redis store");
        RedisConnection connection = null;
        try {
            long lifespan = -1L;
            HashMap<String, byte[]> fields = new HashMap<String, byte[]>();
            if (null != marshalledEntry.getValueBytes()) {
                byte[] value = marshalledEntry.getValueBytes().getBuf();
                fields.put("value", value);
            }
            if (null != marshalledEntry.getMetadataBytes()) {
                byte[] metadata = marshalledEntry.getMetadataBytes().getBuf();
                fields.put("metadata", metadata);
                lifespan = marshalledEntry.getMetadata().lifespan();
            }
            connection = this.connectionPool.getConnection();
            connection.hmset(marshalledEntry.getKey(), fields);
            if (-1L < lifespan) {
                connection.expire(marshalledEntry.getKey(), this.toSeconds(lifespan, marshalledEntry.getKey(), "lifespan"));
            }
        }
        catch (Exception ex) {
            log.error((Object)"Failed to write element to the redis store", (Throwable)ex);
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            if (null != connection) {
                connection.release();
            }
        }
    }

    public boolean delete(Object key) {
        log.debug((Object)"Deleting entry from Redis store");
        RedisConnection connection = null;
        try {
            connection = this.connectionPool.getConnection();
            boolean bl = connection.delete(key);
            return bl;
        }
        catch (Exception ex) {
            log.error((Object)"Failed to delete element from the redis store", (Throwable)ex);
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            if (null != connection) {
                connection.release();
            }
        }
    }

    public boolean contains(Object key) {
        log.debug((Object)"Checking store for Redis entry");
        RedisConnection connection = null;
        try {
            connection = this.connectionPool.getConnection();
            boolean bl = connection.exists(key);
            return bl;
        }
        catch (Exception ex) {
            log.error((Object)"Failed to discover if element is in the redis store", (Throwable)ex);
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            if (null != connection) {
                connection.release();
            }
        }
    }

    private int toSeconds(long millis, Object key, String desc) {
        if (millis > 0L && millis < 1000L) {
            if (log.isTraceEnabled()) {
                log.tracef("Adjusting %s time for (k,v): (%s, %s) from %d millis to 1 sec, as milliseconds are not supported by Redis", (Object)desc, key, (Object)millis);
            }
            return 1;
        }
        return (int)TimeUnit.MILLISECONDS.toSeconds(millis);
    }
}

