/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.redis.client;

import java.security.InvalidParameterException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.persistence.redis.client.RedisClientException;
import org.infinispan.persistence.redis.client.RedisClusterConnectionPool;
import org.infinispan.persistence.redis.client.RedisConnectionPool;
import org.infinispan.persistence.redis.client.RedisSentinelConnectionPool;
import org.infinispan.persistence.redis.client.RedisServerConnectionPool;
import org.infinispan.persistence.redis.client.StringRedisMarshaller;
import org.infinispan.persistence.redis.configuration.RedisStoreConfiguration;

public final class RedisConnectionPoolFactory {
    public static RedisConnectionPool factory(RedisStoreConfiguration configuration, StreamingMarshaller marshaller) throws RedisClientException {
        StringRedisMarshaller redisMarshaller = new StringRedisMarshaller(marshaller);
        switch (configuration.topology()) {
            case CLUSTER: {
                return new RedisClusterConnectionPool(configuration, redisMarshaller);
            }
            case SENTINEL: {
                return new RedisSentinelConnectionPool(configuration, redisMarshaller);
            }
            case SERVER: {
                return new RedisServerConnectionPool(configuration, redisMarshaller);
            }
        }
        throw new InvalidParameterException();
    }
}

