/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.redis.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.infinispan.persistence.redis.client.RedisConnection;
import org.infinispan.persistence.redis.client.RedisMarshaller;
import org.infinispan.persistence.redis.client.RedisServerScanIterable;
import redis.clients.jedis.Jedis;

public final class RedisServerConnection
implements RedisConnection {
    private Jedis client;
    private RedisMarshaller<String> marshaller;

    RedisServerConnection(Jedis client, RedisMarshaller<String> marshaller) {
        this.client = client;
        this.marshaller = marshaller;
    }

    @Override
    public void release() {
        this.client.close();
    }

    @Override
    public Iterable<Object> scan() {
        return new RedisServerScanIterable(this.client, this.marshaller);
    }

    @Override
    public List<byte[]> hmget(Object key, String ... fields) throws IOException, InterruptedException, ClassNotFoundException {
        return this.marshaller.decode(this.client.hmget(this.marshaller.marshall(key), fields));
    }

    @Override
    public void hmset(Object key, Map<String, byte[]> fields) throws IOException, InterruptedException {
        this.client.hmset(this.marshaller.marshall(key), this.marshaller.encode(fields));
    }

    @Override
    public void expire(Object key, int expire) {
        this.client.expire(this.marshaller.marshall(key), expire);
    }

    @Override
    public boolean delete(Object key) throws IOException, InterruptedException {
        return this.client.del(this.marshaller.marshall(key)) > 0L;
    }

    @Override
    public boolean exists(Object key) throws IOException, InterruptedException {
        return this.client.exists(this.marshaller.marshall(key));
    }

    @Override
    public long dbSize() {
        return this.client.dbSize();
    }

    @Override
    public void flushDb() {
        this.client.flushDB();
    }
}

