/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.redis.client;

import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.infinispan.persistence.redis.client.RedisClientException;
import org.infinispan.persistence.redis.client.RedisConnection;
import org.infinispan.persistence.redis.client.RedisConnectionPool;
import org.infinispan.persistence.redis.client.RedisMarshaller;
import org.infinispan.persistence.redis.client.RedisServerConnection;
import org.infinispan.persistence.redis.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.redis.configuration.RedisServerConfiguration;
import org.infinispan.persistence.redis.configuration.RedisStoreConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public final class RedisServerConnectionPool
implements RedisConnectionPool {
    private JedisPool connectionPool;
    private RedisMarshaller<String> marshaller;
    private static final Log log = (Log)LogFactory.getLog(RedisServerConnectionPool.class, Log.class);

    public RedisServerConnectionPool(RedisStoreConfiguration configuration, RedisMarshaller<String> marshaller) throws RedisClientException {
        List<RedisServerConfiguration> servers = configuration.servers();
        if (servers.size() == 0) {
            log.error((Object)"No redis servers defined");
            throw new RedisClientException();
        }
        RedisServerConfiguration server = servers.get(0);
        if (servers.size() > 1) {
            log.warn((Object)String.format("Multiple redis servers defined. Using the first only (%s:%d)", server.host(), server.port()));
        }
        ConnectionPoolConfiguration connectionPoolConfiguration = configuration.connectionPool();
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(connectionPoolConfiguration.maxTotal());
        poolConfig.setMinIdle(connectionPoolConfiguration.minIdle());
        poolConfig.setMaxIdle(connectionPoolConfiguration.maxIdle());
        poolConfig.setMinEvictableIdleTimeMillis(connectionPoolConfiguration.minEvictableIdleTime());
        poolConfig.setTimeBetweenEvictionRunsMillis(connectionPoolConfiguration.timeBetweenEvictionRuns());
        poolConfig.setTestOnCreate(connectionPoolConfiguration.testOnCreate());
        poolConfig.setTestOnBorrow(connectionPoolConfiguration.testOnBorrow());
        poolConfig.setTestOnReturn(connectionPoolConfiguration.testOnReturn());
        poolConfig.setTestWhileIdle(connectionPoolConfiguration.testOnIdle());
        this.connectionPool = new JedisPool((GenericObjectPoolConfig)poolConfig, server.host(), server.port(), configuration.connectionTimeout(), configuration.socketTimeout(), configuration.password(), configuration.database(), null);
        this.marshaller = marshaller;
    }

    @Override
    public RedisConnection getConnection() {
        return new RedisServerConnection(this.connectionPool.getResource(), this.marshaller);
    }

    @Override
    public void shutdown() {
        this.connectionPool.destroy();
    }
}

