/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.redis.configuration;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeInitializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.persistence.redis.RedisStore;
import org.infinispan.persistence.redis.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.redis.configuration.RedisServerConfiguration;
import org.infinispan.persistence.redis.configuration.RedisStoreConfigurationBuilder;

@BuiltBy(value=RedisStoreConfigurationBuilder.class)
@ConfigurationFor(value=RedisStore.class)
public final class RedisStoreConfiguration
extends AbstractStoreConfiguration {
    static final AttributeDefinition<Integer> CONNECTION_TIMEOUT = AttributeDefinition.builder((String)"connectionTimeout", (Object)2000).build();
    static final AttributeDefinition<Integer> SOCKET_TIMEOUT = AttributeDefinition.builder((String)"socketTimeout", (Object)2000).build();
    static final AttributeDefinition<String> MASTER_NAME = AttributeDefinition.builder((String)"masterName", null, String.class).build();
    static final AttributeDefinition<String> PASSWORD = AttributeDefinition.builder((String)"password", null, String.class).build();
    static final AttributeDefinition<Integer> DATABASE = AttributeDefinition.builder((String)"database", (Object)0).build();
    static final AttributeDefinition<Integer> MAX_REDIRECTIONS = AttributeDefinition.builder((String)"maxRedirections", (Object)5).build();
    static final AttributeDefinition<Topology> TOPOLOGY = AttributeDefinition.builder((String)"topology", (Object)((Object)Topology.CLUSTER)).build();
    static final AttributeDefinition<List<RedisServerConfiguration>> SERVERS = AttributeDefinition.builder((String)"servers", null, List.class).initializer((AttributeInitializer)new AttributeInitializer<List<RedisServerConfiguration>>(){

        public List<RedisServerConfiguration> initialize() {
            return new ArrayList<RedisServerConfiguration>();
        }
    }).build();
    static final AttributeDefinition<List<RedisServerConfiguration>> SENTINELS = AttributeDefinition.builder((String)"sentinels", null, List.class).initializer((AttributeInitializer)new AttributeInitializer<List<RedisServerConfiguration>>(){

        public List<RedisServerConfiguration> initialize() {
            return new ArrayList<RedisServerConfiguration>();
        }
    }).build();
    private final ConnectionPoolConfiguration connectionPool;
    private final Attribute<List<RedisServerConfiguration>> servers;
    private final Attribute<List<RedisServerConfiguration>> sentinels;
    private final Attribute<Integer> database;
    private final Attribute<String> password;
    private final Attribute<String> masterName;
    private final Attribute<Topology> topology;
    private final Attribute<Integer> socketTimeout;
    private final Attribute<Integer> connectionTimeout;
    private final Attribute<Integer> maxRedirections;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RedisStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{PASSWORD, DATABASE, SERVERS, SENTINELS, TOPOLOGY, CONNECTION_TIMEOUT, SOCKET_TIMEOUT, MASTER_NAME, MAX_REDIRECTIONS});
    }

    public RedisStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore, ConnectionPoolConfiguration connectionPool) {
        super(attributes, async, singletonStore);
        this.connectionPool = connectionPool;
        this.servers = attributes.attribute(SERVERS);
        this.sentinels = attributes.attribute(SENTINELS);
        this.password = attributes.attribute(PASSWORD);
        this.masterName = attributes.attribute(MASTER_NAME);
        this.database = attributes.attribute(DATABASE);
        this.topology = attributes.attribute(TOPOLOGY);
        this.socketTimeout = attributes.attribute(SOCKET_TIMEOUT);
        this.connectionTimeout = attributes.attribute(CONNECTION_TIMEOUT);
        this.maxRedirections = attributes.attribute(MAX_REDIRECTIONS);
    }

    public List<RedisServerConfiguration> servers() {
        return (List)this.servers.get();
    }

    public List<RedisServerConfiguration> sentinels() {
        return (List)this.sentinels.get();
    }

    public int database() {
        return (Integer)this.database.get();
    }

    public String password() {
        return (String)this.password.get();
    }

    public Topology topology() {
        return (Topology)((Object)this.topology.get());
    }

    public ConnectionPoolConfiguration connectionPool() {
        return this.connectionPool;
    }

    public int connectionTimeout() {
        return (Integer)this.connectionTimeout.get();
    }

    public int socketTimeout() {
        return (Integer)this.socketTimeout.get();
    }

    public String masterName() {
        return (String)this.masterName.get();
    }

    public int maxRedirections() {
        return (Integer)this.maxRedirections.get();
    }

    public static enum Topology {
        CLUSTER,
        SENTINEL,
        SERVER;

    }
}

