/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote;

import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SecurityConfigurationBuilder;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.simple.SimpleServerAuthenticationProvider;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.RemoteStoreSSLTest", groups={"functional"})
public class RemoteStoreSSLTest
extends BaseStoreTest {
    private static final String REMOTE_CACHE = "remote-cache";
    private EmbeddedCacheManager localCacheManager;
    private HotRodServer hrServer;

    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder localBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        this.localCacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)new GlobalConfigurationBuilder().defaultCacheName(REMOTE_CACHE), (ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)localBuilder));
        this.localCacheManager.getCache(REMOTE_CACHE);
        TestingUtil.replaceComponent((CacheContainer)this.localCacheManager, TimeService.class, (Object)this.timeService, (boolean)true);
        this.localCacheManager.getCache(REMOTE_CACHE).getAdvancedCache().getComponentRegistry().rewire();
        ClassLoader cl = RemoteStoreSSLTest.class.getClassLoader();
        SimpleServerAuthenticationProvider sap = new SimpleServerAuthenticationProvider();
        HotRodServerConfigurationBuilder serverBuilder = HotRodTestingUtil.getDefaultHotRodConfiguration();
        serverBuilder.ssl().enable().requireClientAuth(true).keyStoreFileName(cl.getResource("keystore_server.jks").getPath()).keyStorePassword("secret".toCharArray()).keyAlias("hotrod").trustStoreFileName(cl.getResource("ca.jks").getPath()).trustStorePassword("secret".toCharArray());
        serverBuilder.authentication().enable().serverName("localhost").addAllowedMech("EXTERNAL").serverAuthenticationProvider((ServerAuthenticationProvider)sap);
        this.hrServer = new HotRodServer();
        this.hrServer.start((ProtocolServerConfiguration)serverBuilder.build(), this.localCacheManager);
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        SecurityConfigurationBuilder remoteSecurity = ((RemoteStoreConfigurationBuilder)builder.persistence().addStore(RemoteStoreConfigurationBuilder.class)).remoteCacheName(REMOTE_CACHE).remoteSecurity();
        remoteSecurity.ssl().enable().keyStoreFileName(cl.getResource("keystore_client.jks").getPath()).keyStorePassword("secret".toCharArray()).trustStoreFileName(cl.getResource("ca.jks").getPath()).trustStorePassword("secret".toCharArray()).addServer().host(this.hrServer.getHost()).port(this.hrServer.getPort().intValue());
        remoteSecurity.authentication().enable().saslMechanism("EXTERNAL");
        RemoteStore remoteStore = new RemoteStore();
        remoteStore.init(this.createContext(builder.build()));
        return remoteStore;
    }

    protected StreamingMarshaller getMarshaller() {
        return this.localCacheManager.getCache(REMOTE_CACHE).getAdvancedCache().getComponentRegistry().getCacheMarshaller();
    }

    @AfterMethod
    public void tearDown() {
        super.tearDown();
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hrServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.localCacheManager});
    }

    protected boolean storePurgesAllExpired() {
        return false;
    }

    public void testLoadAll() throws PersistenceException {
    }

    public void testReplaceExpiredEntry() throws Exception {
        this.cl.write(this.marshalledEntry(this.internalCacheEntry("k1", "v1", 100L)));
        this.timeService.advance(1101L);
        AssertJUnit.assertNull((Object)this.cl.loadEntry((Object)"k1"));
        long start = System.currentTimeMillis();
        this.cl.write(this.marshalledEntry(this.internalCacheEntry("k1", "v2", 100L)));
        AssertJUnit.assertTrue((this.cl.loadEntry((Object)"k1").getValue().equals("v2") || TestingUtil.moreThanDurationElapsed((long)start, (long)100L) ? 1 : 0) != 0);
    }
}

