/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AsElementAttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.util.Util;
import org.infinispan.persistence.remote.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.Element;

public class AuthenticationConfiguration
implements ConfigurationInfo {
    static final AttributeSerializer<Object, AuthenticationConfiguration, ConfigurationBuilderInfo> NESTED_SASL = new AttributeSerializer<Object, AuthenticationConfiguration, ConfigurationBuilderInfo>(){

        public String getParentElement(AuthenticationConfiguration authentication) {
            return AuthenticationConfiguration.serializeMechanism(authentication.saslMechanism());
        }
    };
    static final AttributeSerializer<String, AuthenticationConfiguration, AuthenticationConfigurationBuilder> MECHANISM_SERIALIZATION = new AsElementAttributeSerializer<String, AuthenticationConfiguration, AuthenticationConfigurationBuilder>(){

        public String getParentElement(AuthenticationConfiguration authentication) {
            return AuthenticationConfiguration.serializeMechanism(authentication.saslMechanism());
        }
    };
    static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false, Boolean.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> USERNAME = AttributeDefinition.builder((String)"username", null, String.class).immutable().serializer(NESTED_SASL).autoPersist(false).build();
    static final AttributeDefinition<String> PASSWORD = AttributeDefinition.builder((String)"password", null, String.class).immutable().autoPersist(false).serializer(NESTED_SASL).build();
    static final AttributeDefinition<String> REALM = AttributeDefinition.builder((String)"realm", null, String.class).immutable().autoPersist(false).serializer(NESTED_SASL).build();
    static final AttributeDefinition<CallbackHandler> CALLBACK_HANDLER = AttributeDefinition.builder((String)"callback-handler", null, CallbackHandler.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<Subject> CLIENT_SUBJECT = AttributeDefinition.builder((String)"client-subject", null, Subject.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> SASL_MECHANISM = AttributeDefinition.builder((String)"sasl-mechanism", null, String.class).serializer(MECHANISM_SERIALIZATION).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> SERVER_NAME = AttributeDefinition.builder((String)"server-name", null, String.class).immutable().build();
    static final AttributeDefinition<Map> SASL_PROPERTIES = AttributeDefinition.builder((String)"sasl-properties", null, Map.class).initializer(HashMap::new).autoPersist(false).immutable().build();
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.AUTHENTICATION.getLocalName());
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AuthenticationConfiguration.class, new AttributeDefinition[]{ENABLED, USERNAME, PASSWORD, REALM, CALLBACK_HANDLER, CLIENT_SUBJECT, SASL_MECHANISM, SERVER_NAME, SASL_PROPERTIES});
    }

    public AuthenticationConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public CallbackHandler callbackHandler() {
        return (CallbackHandler)this.attributes.attribute(CALLBACK_HANDLER).get();
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(ENABLED).get();
    }

    public String username() {
        return (String)this.attributes.attribute(USERNAME).get();
    }

    public char[] password() {
        return Util.toCharArray((String)((String)this.attributes.attribute(PASSWORD).get()));
    }

    public String realm() {
        return (String)this.attributes.attribute(REALM).get();
    }

    public String saslMechanism() {
        return (String)this.attributes.attribute(SASL_MECHANISM).get();
    }

    public Map<String, String> saslProperties() {
        return (Map)this.attributes.attribute(SASL_PROPERTIES).get();
    }

    public String serverName() {
        return (String)this.attributes.attribute(SERVER_NAME).get();
    }

    public Subject clientSubject() {
        return (Subject)this.attributes.attribute(CLIENT_SUBJECT).get();
    }

    public String toString() {
        return this.attributes.toString();
    }

    public boolean equals(Object o) {
        AuthenticationConfiguration other = (AuthenticationConfiguration)o;
        return this.attributes.equals((Object)other.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    private static String serializeMechanism(String mechanism) {
        switch (mechanism) {
            case "PLAIN": {
                return Element.AUTH_PLAIN.getLocalName();
            }
            case "DIGEST-MD5": {
                return Element.AUTH_DIGEST.getLocalName();
            }
            case "EXTERNAL": {
                return Element.AUTH_EXTERNAL.getLocalName();
            }
        }
        throw new CacheConfigurationException("Invalid sasl mechanism");
    }
}

