/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.Element;
import org.infinispan.persistence.remote.configuration.ExhaustedAction;

@BuiltBy(value=ConnectionPoolConfigurationBuilder.class)
public class ConnectionPoolConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<ExhaustedAction> EXHAUSTED_ACTION = AttributeDefinition.builder((String)"exhaustedAction", (Object)((Object)ExhaustedAction.WAIT), ExhaustedAction.class).immutable().build();
    static final AttributeDefinition<Integer> MAX_ACTIVE = AttributeDefinition.builder((String)"maxActive", (Object)-1).immutable().build();
    static final AttributeDefinition<Integer> MAX_TOTAL = AttributeDefinition.builder((String)"maxTotal", (Object)-1).immutable().build();
    static final AttributeDefinition<Integer> MAX_IDLE = AttributeDefinition.builder((String)"maxIdle", (Object)-1).immutable().build();
    static final AttributeDefinition<Integer> MIN_IDLE = AttributeDefinition.builder((String)"minIdle", (Object)-1).immutable().build();
    static final AttributeDefinition<Long> TIME_BETWEEN_EVICTION_RUNS = AttributeDefinition.builder((String)"timeBetweenEvictionRuns", (Object)120000L).immutable().build();
    static final AttributeDefinition<Long> MIN_EVICTABLE_IDLE_TIME = AttributeDefinition.builder((String)"minEvictableIdleTime", (Object)1800000L).immutable().build();
    static final AttributeDefinition<Boolean> TEST_WHILE_IDLE = AttributeDefinition.builder((String)"testWhileIdle", (Object)true).immutable().build();
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.CONNECTION_POOL.getLocalName());
    private final AttributeSet attributes;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ConnectionPoolConfiguration.class, new AttributeDefinition[]{EXHAUSTED_ACTION, MAX_ACTIVE, MAX_TOTAL, MAX_IDLE, MIN_IDLE, TIME_BETWEEN_EVICTION_RUNS, MIN_EVICTABLE_IDLE_TIME, TEST_WHILE_IDLE});
    }

    ConnectionPoolConfiguration(AttributeSet attributes) {
        this.attributes = attributes;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ExhaustedAction exhaustedAction() {
        return (ExhaustedAction)((Object)this.attributes.attribute(EXHAUSTED_ACTION).get());
    }

    public int maxActive() {
        return (Integer)this.attributes.attribute(MAX_ACTIVE).get();
    }

    public int maxTotal() {
        return (Integer)this.attributes.attribute(MAX_TOTAL).get();
    }

    public int maxIdle() {
        return (Integer)this.attributes.attribute(MAX_IDLE).get();
    }

    public int minIdle() {
        return (Integer)this.attributes.attribute(MIN_IDLE).get();
    }

    public long timeBetweenEvictionRuns() {
        return (Long)this.attributes.attribute(TIME_BETWEEN_EVICTION_RUNS).get();
    }

    public long minEvictableIdleTime() {
        return (Long)this.attributes.attribute(MIN_EVICTABLE_IDLE_TIME).get();
    }

    public boolean testWhileIdle() {
        return (Boolean)this.attributes.attribute(TEST_WHILE_IDLE).get();
    }

    public String toString() {
        return "ConnectionPoolConfiguration [exhaustedAction=" + (Object)((Object)this.exhaustedAction()) + ", maxActive=" + this.maxActive() + ", maxTotal=" + this.maxTotal() + ", maxIdle=" + this.maxIdle() + ", minIdle=" + this.minIdle() + ", timeBetweenEvictionRuns=" + this.timeBetweenEvictionRuns() + ", minEvictableIdleTime=" + this.minEvictableIdleTime() + ", testWhileIdle=" + this.testWhileIdle() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionPoolConfiguration that = (ConnectionPoolConfiguration)o;
        if (this.maxActive() != that.maxActive()) {
            return false;
        }
        if (this.maxTotal() != that.maxTotal()) {
            return false;
        }
        if (this.maxIdle() != that.maxIdle()) {
            return false;
        }
        if (this.minIdle() != that.minIdle()) {
            return false;
        }
        if (this.timeBetweenEvictionRuns() != that.timeBetweenEvictionRuns()) {
            return false;
        }
        if (this.minEvictableIdleTime() != that.minEvictableIdleTime()) {
            return false;
        }
        if (this.testWhileIdle() != that.testWhileIdle()) {
            return false;
        }
        return this.exhaustedAction() == that.exhaustedAction();
    }

    public int hashCode() {
        int result = this.exhaustedAction() != null ? this.exhaustedAction().hashCode() : 0;
        result = 31 * result + this.maxActive();
        result = 31 * result + this.maxTotal();
        result = 31 * result + this.maxIdle();
        result = 31 * result + this.minIdle();
        result = 31 * result + (int)(this.timeBetweenEvictionRuns() ^ this.timeBetweenEvictionRuns() >>> 32);
        result = 31 * result + (int)(this.minEvictableIdleTime() ^ this.minEvictableIdleTime() >>> 32);
        result = 31 * result + (this.testWhileIdle() ? 1 : 0);
        return result;
    }
}

