/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.Element;
import org.infinispan.persistence.remote.configuration.ExecutorFactoryConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteServerConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.SecurityConfigurationBuilder;
import org.infinispan.persistence.remote.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<RemoteStoreConfiguration, RemoteStoreConfigurationBuilder>
implements RemoteStoreConfigurationChildBuilder<RemoteStoreConfigurationBuilder>,
ConfigurationBuilderInfo {
    private static final Log log = (Log)LogFactory.getLog(RemoteStoreConfigurationBuilder.class, Log.class);
    private final ExecutorFactoryConfigurationBuilder asyncExecutorFactory;
    private final ConnectionPoolConfigurationBuilder connectionPool;
    private final SecurityConfigurationBuilder security;
    private List<RemoteServerConfigurationBuilder> servers = new ArrayList<RemoteServerConfigurationBuilder>();
    private final List<ConfigurationBuilderInfo> subElements;

    public RemoteStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, RemoteStoreConfiguration.attributeDefinitionSet());
        this.asyncExecutorFactory = new ExecutorFactoryConfigurationBuilder(this);
        this.connectionPool = new ConnectionPoolConfigurationBuilder(this);
        this.security = new SecurityConfigurationBuilder(this);
        this.subElements = new ArrayList<ConfigurationBuilderInfo>(super.getChildrenInfo());
        this.subElements.addAll(Arrays.asList(this.connectionPool, this.asyncExecutorFactory, this.security));
    }

    public RemoteStoreConfigurationBuilder self() {
        return this;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return RemoteStoreConfiguration.ELELEMENT_DEFINITION;
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return this.subElements;
    }

    public ConfigurationBuilderInfo getNewBuilderInfo(String name) {
        if (name.equals(Element.SERVERS.getLocalName())) {
            return this.addServer();
        }
        return this;
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    @Override
    public RemoteStoreConfigurationBuilder balancingStrategy(String balancingStrategy) {
        this.attributes.attribute(RemoteStoreConfiguration.BALANCING_STRATEGY).set((Object)balancingStrategy);
        return this;
    }

    @Override
    public ConnectionPoolConfigurationBuilder connectionPool() {
        return this.connectionPool;
    }

    @Override
    public RemoteStoreConfigurationBuilder connectionTimeout(long connectionTimeout) {
        this.attributes.attribute(RemoteStoreConfiguration.CONNECTION_TIMEOUT).set((Object)connectionTimeout);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder forceReturnValues(boolean forceReturnValues) {
        this.attributes.attribute(RemoteStoreConfiguration.FORCE_RETURN_VALUES).set((Object)forceReturnValues);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder hotRodWrapping(boolean hotRodWrapping) {
        this.attributes.attribute(RemoteStoreConfiguration.HOTROD_WRAPPING).set((Object)hotRodWrapping);
        this.rawValues(true);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder keySizeEstimate(int keySizeEstimate) {
        this.attributes.attribute(RemoteStoreConfiguration.KEY_SIZE_ESTIMATE).set((Object)keySizeEstimate);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder marshaller(String marshaller) {
        this.attributes.attribute(RemoteStoreConfiguration.MARSHALLER).set((Object)marshaller);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder marshaller(Class<? extends Marshaller> marshaller) {
        this.marshaller(marshaller.getName());
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder protocolVersion(ProtocolVersion protocolVersion) {
        this.attributes.attribute(RemoteStoreConfiguration.PROTOCOL_VERSION).set((Object)protocolVersion);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder rawValues(boolean rawValues) {
        this.attributes.attribute(RemoteStoreConfiguration.RAW_VALUES).set((Object)rawValues);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder remoteCacheName(String remoteCacheName) {
        this.attributes.attribute(RemoteStoreConfiguration.REMOTE_CACHE_NAME).set((Object)remoteCacheName);
        return this;
    }

    @Override
    public SecurityConfigurationBuilder remoteSecurity() {
        return this.security;
    }

    @Override
    public RemoteStoreConfigurationBuilder socketTimeout(long socketTimeout) {
        this.attributes.attribute(RemoteStoreConfiguration.SOCKET_TIMEOUT).set((Object)socketTimeout);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.attributes.attribute(RemoteStoreConfiguration.TCP_NO_DELAY).set((Object)tcpNoDelay);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder transportFactory(String transportFactory) {
        this.attributes.attribute(RemoteStoreConfiguration.TRANSPORT_FACTORY).set((Object)transportFactory);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder transportFactory(Class<? extends ChannelFactory> transportFactory) {
        this.transportFactory(transportFactory.getName());
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder valueSizeEstimate(int valueSizeEstimate) {
        this.attributes.attribute(RemoteStoreConfiguration.VALUE_SIZE_ESTIMATE).set((Object)valueSizeEstimate);
        return this;
    }

    @Override
    public RemoteServerConfigurationBuilder addServer() {
        RemoteServerConfigurationBuilder builder = new RemoteServerConfigurationBuilder(this);
        this.servers.add(builder);
        return builder;
    }

    public RemoteStoreConfiguration create() {
        ArrayList<RemoteServerConfiguration> remoteServers = new ArrayList<RemoteServerConfiguration>();
        for (RemoteServerConfigurationBuilder server : this.servers) {
            remoteServers.add(server.create());
        }
        this.attributes.attribute(RemoteStoreConfiguration.SERVERS).set(remoteServers);
        return new RemoteStoreConfiguration(this.attributes.protect(), this.async.create(), this.asyncExecutorFactory.create(), this.connectionPool.create(), this.security.create());
    }

    public RemoteStoreConfigurationBuilder read(RemoteStoreConfiguration template) {
        super.read((StoreConfiguration)template);
        this.asyncExecutorFactory.read(template.asyncExecutorFactory());
        this.connectionPool.read(template.connectionPool());
        for (RemoteServerConfiguration server : template.servers()) {
            this.addServer().host(server.host()).port(server.port());
        }
        this.security.read(template.security());
        return this;
    }

    public RemoteStoreConfigurationBuilder withProperties(Properties props) {
        String version = (String)props.remove(RemoteStoreConfiguration.PROTOCOL_VERSION.name());
        if (version != null) {
            this.protocolVersion(ProtocolVersion.parseVersion((String)version));
        }
        return (RemoteStoreConfigurationBuilder)super.withProperties(props);
    }

    public void validate() {
        this.connectionPool.validate();
        this.asyncExecutorFactory.validate();
        for (RemoteServerConfigurationBuilder server : this.servers) {
            server.validate();
        }
        if (((Boolean)this.attributes.attribute(RemoteStoreConfiguration.HOTROD_WRAPPING).get()).booleanValue() && this.attributes.attribute(RemoteStoreConfiguration.MARSHALLER).get() != null) {
            throw log.cannotEnableHotRodWrapping();
        }
        ProtocolVersion version = (ProtocolVersion)this.attributes.attribute(RemoteStoreConfiguration.PROTOCOL_VERSION).get();
        ProtocolVersion minimumVersion = ProtocolVersion.PROTOCOL_VERSION_23;
        if (((Boolean)this.attributes.attribute(AbstractStoreConfiguration.SEGMENTED).get()).booleanValue() && version.compareTo((Enum)minimumVersion) < 0) {
            throw log.segmentationNotSupportedInThisVersion(minimumVersion);
        }
    }
}

