/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.configuration.ExhaustedAction;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.remote.configuration.XmlFileParsingTest")
public class XmlFileParsingTest
extends AbstractInfinispanTest {
    private EmbeddedCacheManager cacheManager;

    @AfterMethod
    public void cleanup() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    public void testRemoteCacheStore() throws Exception {
        String config = TestingUtil.wrapXMLWithSchema((String)("<cache-container default-cache=\"default\">   <local-cache name=\"default\">\n     <persistence>\n       <remote-store xmlns=\"urn:infinispan:config:store:remote:" + Version.getSchemaVersion() + "\" >\n         <remote-server host=\"one\" />\n         <remote-server host=\"two\" />\n         <connection-pool max-active=\"10\" exhausted-action=\"CREATE_NEW\" />\n         <async-executor>\n             <property name=\"maxThreads\">4</property>         </async-executor>\n         <write-behind/>\n       </remote-store>\n     </persistence>\n   </local-cache>\n</cache-container>"));
        RemoteStoreConfiguration store = (RemoteStoreConfiguration)this.buildCacheManagerWithCacheStore(config);
        AssertJUnit.assertEquals((int)2, (int)store.servers().size());
        AssertJUnit.assertEquals((Object)ExhaustedAction.CREATE_NEW, (Object)store.connectionPool().exhaustedAction());
        AssertJUnit.assertEquals((int)4, (int)store.asyncExecutorFactory().properties().getIntProperty("maxThreads", 0));
        AssertJUnit.assertTrue((boolean)store.async().enabled());
    }

    private StoreConfiguration buildCacheManagerWithCacheStore(String config) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is);
        assert (this.cacheManager.getDefaultCacheConfiguration().persistence().stores().size() == 1);
        return (StoreConfiguration)this.cacheManager.getDefaultCacheConfiguration().persistence().stores().get(0);
    }
}

