package org.infinispan.persistence.remote.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-02-10T11:06:58+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String missingMigrationData = "ISPN000276: Could not find migration data in cache %s";
    protected String missingMigrationData$str() {
        return missingMigrationData;
    }
    @Override
    public final CacheException missingMigrationData(final String name) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), missingMigrationData$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void keyMigrationFailed(final String key, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, keyMigrationFailed$str(), key);
    }
    private static final String keyMigrationFailed = "ISPN000277: Could not migrate key %s";
    protected String keyMigrationFailed$str() {
        return keyMigrationFailed;
    }
    @Override
    public final void ignoreXmlAttribute(final Object attribute) {
        super.log.logf(FQCN, INFO, null, ignoreXmlAttribute$str(), attribute);
    }
    private static final String ignoreXmlAttribute = "ISPN000293: Ignoring XML attribute %s, please remove from configuration file";
    protected String ignoreXmlAttribute$str() {
        return ignoreXmlAttribute;
    }
    private static final String couldNotMigrateData = "ISPN000397: Could not migrate data for cache %s, check remote store config in the target cluster. Make sure only one remote store is present and is pointing to the source cluster";
    protected String couldNotMigrateData$str() {
        return couldNotMigrateData;
    }
    @Override
    public final CacheException couldNotMigrateData(final String name) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), couldNotMigrateData$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotEnableHotRodWrapping = "ISPN010005: Cannot enable HotRod wrapping if a marshaller and/or an entryWrapper have already been set";
    protected String cannotEnableHotRodWrapping$str() {
        return cannotEnableHotRodWrapping;
    }
    @Override
    public final CacheConfigurationException cannotEnableHotRodWrapping() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotEnableHotRodWrapping$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String remoteStoreNoHotRodWrapping = "ISPN010007: The RemoteCacheStore for cache %s should be configured with hotRodWrapping enabled";
    protected String remoteStoreNoHotRodWrapping$str() {
        return remoteStoreNoHotRodWrapping;
    }
    @Override
    public final CacheException remoteStoreNoHotRodWrapping(final String cacheName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), remoteStoreNoHotRodWrapping$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String segmentationNotSupportedInThisVersion = "ISPN010008: RemoteStore only supports segmentation when using at least protocol version %s or higher";
    protected String segmentationNotSupportedInThisVersion$str() {
        return segmentationNotSupportedInThisVersion;
    }
    @Override
    public final CacheConfigurationException segmentationNotSupportedInThisVersion(final ProtocolVersion version) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), segmentationNotSupportedInThisVersion$str(), version));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
