/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote;

import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.GetWithMetadataTest", groups={"functional"})
public class GetWithMetadataTest
extends AbstractInfinispanTest {
    public static final String CACHE_NAME = "testCache";

    private <K, V> RemoteCache<K, V> getRemoteCache(HotRodServer hotRodServer) {
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(HotRodClientTestingUtil.newRemoteConfigurationBuilder((HotRodServer)hotRodServer).marshaller(GenericJBossMarshaller.class).build());
        return remoteCacheManager.getCache(CACHE_NAME);
    }

    protected ConfigurationBuilder getTargetCacheConfiguration(int sourcePort) {
        ConfigurationBuilder cb = HotRodTestingUtil.hotRodCacheConfiguration((MediaType)MediaType.APPLICATION_JBOSS_MARSHALLING);
        ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)cb.persistence().addStore(RemoteStoreConfigurationBuilder.class)).remoteCacheName(CACHE_NAME).hotRodWrapping(true).segmented(false)).addServer().host("localhost").port(sourcePort).shared(true);
        return cb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetWithMetadata() {
        RemoteCacheManager remoteCacheManager;
        EmbeddedCacheManager sourceCacheManager = null;
        EmbeddedCacheManager targetCacheManager = null;
        HotRodServer sourceServer = null;
        HotRodServer targetServer = null;
        RemoteCache sourceRemoteCache = null;
        RemoteCache targetRemoteCache = null;
        try {
            sourceCacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
            sourceCacheManager.defineConfiguration(CACHE_NAME, HotRodTestingUtil.hotRodCacheConfiguration((MediaType)MediaType.APPLICATION_JBOSS_MARSHALLING).build());
            sourceServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)sourceCacheManager);
            sourceRemoteCache = this.getRemoteCache(sourceServer);
            sourceRemoteCache.put((Object)"key", (Object)"value");
            sourceRemoteCache.put((Object)"key2", (Object)"value2", 24L, TimeUnit.HOURS, 1L, TimeUnit.DAYS);
            sourceRemoteCache.put((Object)"key3", (Object)"value2");
            MetadataValue key2Metadata = sourceRemoteCache.getWithMetadata((Object)"key2");
            long k2Created = key2Metadata.getCreated();
            targetCacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((MediaType)MediaType.APPLICATION_JBOSS_MARSHALLING));
            targetServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)targetCacheManager);
            ConfigurationBuilder targetCacheConfiguration = this.getTargetCacheConfiguration(sourceServer.getPort());
            targetCacheManager.defineConfiguration(CACHE_NAME, targetCacheConfiguration.build());
            targetRemoteCache = this.getRemoteCache(targetServer);
            MetadataValue metadataEntry = targetRemoteCache.getWithMetadata((Object)"key");
            Assert.assertNotNull((Object)metadataEntry);
            MetadataValue otherMetadataEntry = targetRemoteCache.getWithMetadata((Object)"key2");
            Assert.assertNotNull((Object)otherMetadataEntry);
            Assert.assertEquals((int)otherMetadataEntry.getLifespan(), (int)86400);
            Assert.assertEquals((int)otherMetadataEntry.getMaxIdle(), (int)86400);
            Assert.assertEquals((long)otherMetadataEntry.getCreated(), (long)k2Created);
            Assert.assertTrue((otherMetadataEntry.getLastUsed() > 0L ? 1 : 0) != 0);
            remoteCacheManager = targetRemoteCache != null ? targetRemoteCache.getRemoteCacheManager() : null;
        }
        catch (Throwable throwable) {
            HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheManager)(targetRemoteCache != null ? targetRemoteCache.getRemoteCacheManager() : null));
            HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheManager)(sourceRemoteCache != null ? sourceRemoteCache.getRemoteCacheManager() : null));
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{targetCacheManager, sourceCacheManager});
            HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{targetServer, sourceServer});
            throw throwable;
        }
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheManager)remoteCacheManager);
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheManager)(sourceRemoteCache != null ? sourceRemoteCache.getRemoteCacheManager() : null));
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{targetCacheManager, sourceCacheManager});
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{targetServer, sourceServer});
    }
}

