/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote;

import java.io.IOException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.persistence.BaseNonBlockingStoreTest;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SecurityConfigurationBuilder;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.simple.SimpleServerAuthenticationProvider;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.RemoteStoreSSLTest", groups={"functional"})
public class RemoteStoreSSLTest
extends BaseNonBlockingStoreTest {
    private static final String REMOTE_CACHE = "remote-cache";
    private EmbeddedCacheManager localCacheManager;
    private HotRodServer hrServer;

    protected Configuration buildConfig(ConfigurationBuilder builder) {
        this.localCacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)new GlobalConfigurationBuilder().defaultCacheName(REMOTE_CACHE), (ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)builder));
        ClassLoader cl = RemoteStoreSSLTest.class.getClassLoader();
        if (this.hrServer == null) {
            this.localCacheManager.getCache(REMOTE_CACHE);
            TestingUtil.replaceComponent((CacheContainer)this.localCacheManager, TimeService.class, (Object)this.timeService, (boolean)true);
            this.localCacheManager.getCache(REMOTE_CACHE).getAdvancedCache().getComponentRegistry().rewire();
            SimpleServerAuthenticationProvider sap = new SimpleServerAuthenticationProvider();
            HotRodServerConfigurationBuilder serverBuilder = HotRodTestingUtil.getDefaultHotRodConfiguration();
            serverBuilder.ssl().enable().requireClientAuth(true).keyStoreFileName(cl.getResource("keystore_server.jks").getPath()).keyStorePassword("secret".toCharArray()).keyAlias("hotrod").trustStoreFileName(cl.getResource("ca.jks").getPath()).trustStorePassword("secret".toCharArray());
            serverBuilder.authentication().enable().serverName("localhost").addAllowedMech("EXTERNAL").serverAuthenticationProvider((ServerAuthenticationProvider)sap);
            this.hrServer = new HotRodServer();
            this.hrServer.start((ProtocolServerConfiguration)serverBuilder.build(), this.localCacheManager);
        }
        SecurityConfigurationBuilder remoteSecurity = ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)builder.persistence().addStore(RemoteStoreConfigurationBuilder.class)).remoteCacheName(REMOTE_CACHE).shared(true)).segmented(false)).remoteSecurity();
        remoteSecurity.ssl().enable().keyStoreFileName(cl.getResource("keystore_client.jks").getPath()).keyStorePassword("secret".toCharArray()).trustStoreFileName(cl.getResource("ca.jks").getPath()).trustStorePassword("secret".toCharArray()).addServer().host(this.hrServer.getHost()).port(this.hrServer.getPort().intValue());
        remoteSecurity.authentication().enable().saslMechanism("EXTERNAL");
        return builder.build();
    }

    protected NonBlockingStore createStore() throws Exception {
        return new RemoteStore();
    }

    protected PersistenceMarshaller getMarshaller() {
        return this.localCacheManager.getCache(REMOTE_CACHE).getAdvancedCache().getComponentRegistry().getPersistenceMarshaller();
    }

    @AfterMethod
    public void tearDown() {
        super.tearDown();
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hrServer});
        this.hrServer = null;
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.localCacheManager});
    }

    protected Object keyToStorage(Object key) {
        try {
            return new WrappedByteArray(this.marshaller.objectToByteBuffer(key));
        }
        catch (IOException | InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected boolean storePurgesAllExpired() {
        return false;
    }
}

