/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote;

import io.reactivex.rxjava3.core.Flowable;
import java.io.IOException;
import java.util.function.Predicate;
import java.util.function.ToIntBiFunction;
import org.infinispan.AdvancedCache;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.marshall.protostream.impl.MarshallableUserObject;
import org.infinispan.persistence.BaseNonBlockingStoreTest;
import org.infinispan.persistence.internal.PersistenceUtil;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.reactivestreams.Publisher;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.RemoteStoreTest", groups={"functional"})
public class RemoteStoreTest
extends BaseNonBlockingStoreTest {
    private static final String REMOTE_CACHE = "remote-cache";
    private EmbeddedCacheManager localCacheManager;
    private AdvancedCache<Object, Object> localCache;
    private HotRodServer hrServer;
    private boolean segmented;
    private MediaType cacheMediaType;
    private boolean isRawValues;
    private ProtoStreamMarshaller marshaller = new ProtoStreamMarshaller(ProtobufUtil.newSerializationContext());

    public RemoteStoreTest segmented(boolean segmented) {
        this.segmented = segmented;
        return this;
    }

    public RemoteStoreTest cacheMediaType(MediaType cacheMediaType) {
        this.cacheMediaType = cacheMediaType;
        return this;
    }

    public RemoteStoreTest rawValues(boolean isRawValues) {
        this.isRawValues = isRawValues;
        return this;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new RemoteStoreTest().segmented(false).cacheMediaType(MediaType.APPLICATION_OBJECT).rawValues(true), new RemoteStoreTest().segmented(false).cacheMediaType(MediaType.APPLICATION_OBJECT).rawValues(false), new RemoteStoreTest().segmented(false).cacheMediaType(MediaType.APPLICATION_PROTOSTREAM).rawValues(true), new RemoteStoreTest().segmented(false).cacheMediaType(MediaType.APPLICATION_PROTOSTREAM).rawValues(false), new RemoteStoreTest().segmented(true).cacheMediaType(MediaType.APPLICATION_OBJECT).rawValues(true), new RemoteStoreTest().segmented(true).cacheMediaType(MediaType.APPLICATION_OBJECT).rawValues(false), new RemoteStoreTest().segmented(true).cacheMediaType(MediaType.APPLICATION_PROTOSTREAM).rawValues(true), new RemoteStoreTest().segmented(true).cacheMediaType(MediaType.APPLICATION_PROTOSTREAM).rawValues(false)};
    }

    protected String parameters() {
        return "[" + this.segmented + ", " + this.cacheMediaType + ", " + this.isRawValues + "]";
    }

    protected Configuration buildConfig(ConfigurationBuilder cb) {
        cb.memory().maxCount(120L).expiration().wakeUpInterval(10L);
        if (this.hrServer == null) {
            GlobalConfigurationBuilder globalConfig = new GlobalConfigurationBuilder().clusteredDefault();
            globalConfig.defaultCacheName(REMOTE_CACHE);
            ConfigurationBuilder configurationBuilder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)cb);
            configurationBuilder.encoding().mediaType(this.cacheMediaType.toString());
            configurationBuilder.clustering().cacheMode(CacheMode.DIST_SYNC);
            this.localCacheManager = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalConfig, (ConfigurationBuilder)configurationBuilder);
            TestingUtil.replaceComponent((CacheContainer)this.localCacheManager, TimeService.class, (Object)this.timeService, (boolean)true);
            this.localCache = this.localCacheManager.getCache(REMOTE_CACHE).getAdvancedCache().withMediaType(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OBJECT);
            this.keyPartitioner = (KeyPartitioner)this.localCache.getAdvancedCache().getComponentRegistry().getComponent(KeyPartitioner.class);
            this.hrServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.localCacheManager);
        }
        cb.clustering().cacheMode(CacheMode.DIST_SYNC);
        cb.encoding().mediaType(this.cacheMediaType.toString());
        RemoteStoreConfigurationBuilder storeConfigurationBuilder = ((RemoteStoreConfigurationBuilder)cb.persistence().addStore(RemoteStoreConfigurationBuilder.class)).remoteCacheName(REMOTE_CACHE).rawValues(this.isRawValues);
        storeConfigurationBuilder.addServer().host(this.hrServer.getHost()).port(this.hrServer.getPort().intValue());
        storeConfigurationBuilder.segmented(this.segmented);
        storeConfigurationBuilder.shared(true);
        return cb.build();
    }

    protected NonBlockingStore createStore() {
        return new RemoteStore();
    }

    protected PersistenceMarshaller getMarshaller() {
        return this.localCacheManager.getCache(REMOTE_CACHE).getAdvancedCache().getComponentRegistry().getPersistenceMarshaller();
    }

    @AfterMethod
    public void tearDown() {
        super.tearDown();
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hrServer});
        this.hrServer = null;
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.localCacheManager});
    }

    protected boolean storePurgesAllExpired() {
        return false;
    }

    protected Object keyToStorage(Object key) {
        if (this.cacheMediaType.equals((Object)MediaType.APPLICATION_PROTOSTREAM)) {
            try {
                return new WrappedByteArray(this.marshaller.objectToByteBuffer(key));
            }
            catch (IOException | InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
        return super.keyToStorage(key);
    }

    protected Object valueToStorage(Object value) {
        return this.keyToStorage(value);
    }

    public void testReplaceExpiredEntry() {
        this.store.write(this.marshalledEntry(this.internalCacheEntry("k1", "v1", 100L)));
        this.timeService.advance(1101L);
        Object storedKey = this.keyToStorage("k1");
        AssertJUnit.assertNull((Object)this.store.loadEntry(storedKey));
        long start = System.currentTimeMillis();
        this.store.write(this.marshalledEntry(this.internalCacheEntry("k1", "v2", 100L)));
        AssertJUnit.assertTrue((this.store.loadEntry(storedKey).getValue().equals(this.valueToStorage("v2")) || TestingUtil.moreThanDurationElapsed((long)start, (long)100L) ? 1 : 0) != 0);
    }

    void countWithSegments(ToIntBiFunction<NonBlockingStore<Object, Object>, IntSet> countFunction) {
        this.store.write(this.marshalledEntry(this.internalCacheEntry("k1", "v1", 100L)));
        int segment = this.getKeySegment("k1");
        AssertJUnit.assertEquals((int)1, (int)countFunction.applyAsInt((NonBlockingStore<Object, Object>)this.store, IntSets.immutableSet((int)segment)));
        int maxSegments = this.localCache.getCacheConfiguration().clustering().hash().numSegments();
        IntSet intSet = IntSets.mutableEmptySet((int)maxSegments);
        for (int i = 0; i < maxSegments; ++i) {
            if (i == segment) continue;
            intSet.set(i);
        }
        AssertJUnit.assertEquals((int)0, (int)countFunction.applyAsInt((NonBlockingStore<Object, Object>)this.store, intSet));
    }

    int getKeySegment(Object obj) {
        Object key = this.keyToStorage(obj);
        if (this.segmented && !this.isRawValues && this.cacheMediaType.equals((Object)MediaType.APPLICATION_OBJECT)) {
            key = new MarshallableUserObject(key);
        }
        return this.keyPartitioner.getSegment(key);
    }

    public void testPublishKeysWithSegments() {
        this.countWithSegments((salws, intSet) -> {
            Predicate predicate;
            IntSet segments;
            if (this.segmented) {
                segments = intSet;
                predicate = null;
            } else {
                segments = null;
                predicate = PersistenceUtil.combinePredicate((IntSet)intSet, (KeyPartitioner)this.keyPartitioner, null);
            }
            return ((Long)Flowable.fromPublisher((Publisher)salws.publishKeys(segments, predicate)).count().blockingGet()).intValue();
        });
    }

    public void testPublishEntriesWithSegments() {
        this.countWithSegments((salws, intSet) -> {
            Predicate predicate;
            IntSet segments;
            if (this.segmented) {
                segments = intSet;
                predicate = null;
            } else {
                segments = null;
                predicate = PersistenceUtil.combinePredicate((IntSet)intSet, (KeyPartitioner)this.keyPartitioner, null);
            }
            return ((Long)Flowable.fromPublisher((Publisher)salws.publishEntries(segments, predicate, false)).count().blockingGet()).intValue();
        });
    }

    @Test(enabled=false)
    public void testLoadAndStoreBytesValues() throws PersistenceException, IOException, InterruptedException {
    }
}

