/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.testng.Assert;

class TestCluster {
    private List<HotRodServer> hotRodServers;
    private List<EmbeddedCacheManager> embeddedCacheManagers;
    private RemoteCacheManager remoteCacheManager;

    private TestCluster(List<HotRodServer> hotRodServers, List<EmbeddedCacheManager> embeddedCacheManagers, RemoteCacheManager remoteCacheManager) {
        this.hotRodServers = hotRodServers;
        this.embeddedCacheManagers = embeddedCacheManagers;
        this.remoteCacheManager = remoteCacheManager;
    }

    RemoteCache<String, String> getRemoteCache(String cacheName) {
        return this.remoteCacheManager.getCache(cacheName);
    }

    void destroy() {
        this.embeddedCacheManagers.forEach(xva$0 -> TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{xva$0}));
        this.embeddedCacheManagers.clear();
        this.hotRodServers.forEach(xva$0 -> HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{xva$0}));
        this.hotRodServers.clear();
        HotRodClientTestingUtil.killRemoteCacheManagers((RemoteCacheManager[])new RemoteCacheManager[]{this.remoteCacheManager});
        this.remoteCacheManager = null;
    }

    Cache<Object, Object> getEmbeddedCache(String name) {
        return this.embeddedCacheManagers.get(0).getCache(name);
    }

    List<Cache<String, String>> getEmbeddedCaches(String name) {
        return this.embeddedCacheManagers.stream().map(cm -> cm.getCache(name)).collect(Collectors.toList());
    }

    RollingUpgradeManager getRollingUpgradeManager(String cacheName) {
        return (RollingUpgradeManager)this.embeddedCacheManagers.get(0).getCache(cacheName).getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
    }

    int getHotRodPort() {
        return this.hotRodServers.get(0).getPort();
    }

    void cleanAllCaches() {
        this.embeddedCacheManagers.stream().flatMap(m -> m.getCacheNames().stream().map(arg_0 -> ((EmbeddedCacheManager)m).getCache(arg_0))).forEach(Cache::clear);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String members = this.embeddedCacheManagers.stream().map(EmbeddedCacheManager::getMembers).map(Object::toString).collect(Collectors.joining(","));
        sb.append("Cluster members: ").append(members);
        String addresses = this.hotRodServers.stream().map(HotRodServer::getAddress).map(Object::toString).collect(Collectors.joining(","));
        sb.append("Servers: ").append(addresses);
        sb.append(addresses);
        return sb.toString();
    }

    public void disconnectSource(String cacheName) {
        this.embeddedCacheManagers.forEach(c -> {
            RollingUpgradeManager rum = (RollingUpgradeManager)c.getCache(cacheName).getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
            try {
                rum.disconnectSource("hotrod");
            }
            catch (Exception e) {
                Assert.fail((String)"Failed to disconnect source!");
            }
        });
    }

    static class Builder {
        private String name = "cluster1";
        private int numMembers = 1;
        private Map<String, org.infinispan.configuration.cache.ConfigurationBuilder> caches = new HashMap<String, org.infinispan.configuration.cache.ConfigurationBuilder>();
        private HotRodServerConfigurationBuilder hotRodBuilder = new HotRodServerConfigurationBuilder();
        private String trustStoreFileName;
        private char[] trustStorePassword;
        private char[] keyStorePassword;
        private String keyStoreFileName;
        private boolean segmented;

        Builder() {
        }

        Builder setNumMembers(int numMembers) {
            this.numMembers = numMembers;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        CacheDefinitionBuilder cache() {
            return new CacheDefinitionBuilder(this);
        }

        Builder withHotRodBuilder(HotRodServerConfigurationBuilder hotRodBuilder) {
            this.hotRodBuilder = hotRodBuilder;
            return this;
        }

        Builder withSSLTrustStore(String trustStoreFileName, char[] trustStorePassword) {
            this.trustStoreFileName = trustStoreFileName;
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        Builder withSSLKeyStore(String keyStoreFileName, char[] keyStorePassword) {
            this.keyStoreFileName = keyStoreFileName;
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        Builder segmented(boolean segmented) {
            this.segmented = segmented;
            return this;
        }

        private void addCache(String name, org.infinispan.configuration.cache.ConfigurationBuilder cfg) {
            this.caches.put(name, cfg);
        }

        public TestCluster build() {
            ArrayList<HotRodServer> hotRodServers = new ArrayList<HotRodServer>();
            ArrayList<EmbeddedCacheManager> embeddedCacheManagers = new ArrayList<EmbeddedCacheManager>();
            for (int i = 0; i < this.numMembers; ++i) {
                GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
                ((PrivateGlobalConfigurationBuilder)gcb.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
                gcb.transport().defaultTransport().clusterName(this.name);
                EmbeddedCacheManager clusteredCacheManager = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)gcb, (org.infinispan.configuration.cache.ConfigurationBuilder)AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC));
                this.caches.entrySet().forEach(entry -> clusteredCacheManager.defineConfiguration((String)entry.getKey(), ((org.infinispan.configuration.cache.ConfigurationBuilder)entry.getValue()).build()));
                embeddedCacheManagers.add(clusteredCacheManager);
                hotRodServers.add(HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)clusteredCacheManager, (HotRodServerConfigurationBuilder)this.hotRodBuilder));
            }
            int port = ((HotRodServer)hotRodServers.get(0)).getPort();
            ConfigurationBuilder build = new ConfigurationBuilder();
            build.addServer().port(port).host("localhost");
            if (this.trustStoreFileName != null) {
                build.security().ssl().enable().trustStoreFileName(this.trustStoreFileName).trustStorePassword(this.trustStorePassword);
            }
            if (this.keyStoreFileName != null) {
                build.security().ssl().keyStoreFileName(this.keyStoreFileName).keyStorePassword(this.keyStorePassword);
            }
            return new TestCluster(hotRodServers, embeddedCacheManagers, new RemoteCacheManager(build.marshaller(GenericJBossMarshaller.class).build()));
        }

        static class CacheDefinitionBuilder {
            private final Builder builder;
            private org.infinispan.configuration.cache.ConfigurationBuilder configurationBuilder;
            private String name;
            private ProtocolVersion protocolVersion = ProtocolVersion.DEFAULT_PROTOCOL_VERSION;
            private Integer remotePort;

            CacheDefinitionBuilder(Builder builder) {
                this.builder = builder;
            }

            public CacheDefinitionBuilder name(String name) {
                this.name = name;
                return this;
            }

            CacheDefinitionBuilder remotePort(Integer remotePort) {
                this.remotePort = remotePort;
                return this;
            }

            CacheDefinitionBuilder remoteProtocolVersion(ProtocolVersion version) {
                this.protocolVersion = version;
                return this;
            }

            CacheDefinitionBuilder configuredWith(org.infinispan.configuration.cache.ConfigurationBuilder configurationBuilder) {
                this.configurationBuilder = configurationBuilder;
                return this;
            }

            CacheDefinitionBuilder cache() {
                return this.addNewCache();
            }

            TestCluster build() {
                this.addNewCache();
                return this.builder.build();
            }

            private CacheDefinitionBuilder addNewCache() {
                if (this.configurationBuilder == null) {
                    this.configurationBuilder = AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC);
                }
                if (this.remotePort != null) {
                    RemoteStoreConfigurationBuilder store = (RemoteStoreConfigurationBuilder)this.configurationBuilder.persistence().addStore(RemoteStoreConfigurationBuilder.class);
                    ((RemoteStoreConfigurationBuilder)store.hotRodWrapping(true).remoteCacheName(this.name).protocolVersion(this.protocolVersion).shared(true)).addServer().host("localhost").port(this.remotePort.intValue());
                    if (this.builder.trustStoreFileName != null) {
                        store.remoteSecurity().ssl().enable().trustStoreFileName(this.builder.trustStoreFileName).trustStorePassword(this.builder.trustStorePassword);
                    }
                    if (this.builder.keyStoreFileName != null) {
                        store.remoteSecurity().ssl().keyStoreFileName(this.builder.keyStoreFileName).keyStorePassword(this.builder.keyStorePassword);
                    }
                    if (this.builder.segmented) {
                        if (this.protocolVersion.compareTo((Enum)ProtocolVersion.PROTOCOL_VERSION_23) < 0) {
                            throw new AssertionError((Object)"Protocol version less than 2.3 cannot be segmented");
                        }
                        store.segmented(true);
                    } else {
                        store.segmented(false);
                    }
                }
                this.builder.addCache(this.name, this.configurationBuilder);
                return new CacheDefinitionBuilder(this.builder);
            }
        }
    }
}

