/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.Arrays;
import java.util.Collection;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.persistence.remote.configuration.AbstractRemoteStoreConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SecurityConfiguration;
import org.infinispan.persistence.remote.configuration.SslConfigurationBuilder;

public class SecurityConfigurationBuilder
extends AbstractRemoteStoreConfigurationChildBuilder
implements Builder<SecurityConfiguration>,
ConfigurationBuilderInfo {
    private final AuthenticationConfigurationBuilder authentication = new AuthenticationConfigurationBuilder(this);
    private final SslConfigurationBuilder ssl = new SslConfigurationBuilder(this);

    SecurityConfigurationBuilder(RemoteStoreConfigurationBuilder builder) {
        super(builder, null);
    }

    public AuthenticationConfigurationBuilder authentication() {
        return this.authentication;
    }

    public SslConfigurationBuilder ssl() {
        return this.ssl;
    }

    public SecurityConfiguration create() {
        return new SecurityConfiguration(this.authentication.create(), this.ssl.create());
    }

    public Builder<?> read(SecurityConfiguration template) {
        this.authentication.read(template.authentication());
        this.ssl.read(template.ssl());
        return this;
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return Arrays.asList(this.authentication, this.ssl);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return SecurityConfiguration.ELEMENT_DEFINITION;
    }

    public void validate() {
        this.authentication.validate();
        this.ssl.validate();
    }

    public String toString() {
        return "SecurityConfigurationBuilder{authentication=" + this.authentication + ", ssl=" + this.ssl + '}';
    }
}

