package org.infinispan.persistence.remote.logging;

import java.util.Locale;
import java.io.Serializable;
import org.infinispan.commons.marshall.Marshaller;
import javax.annotation.processing.Generated;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.infinispan.client.hotrod.ProtocolVersion;
import java.lang.Integer;
import org.jboss.logging.BasicLogger;
import org.infinispan.commons.dataconversion.MediaType;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2025-02-27T13:12:37-0500")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void ignoreXmlAttribute(final Object attribute) {
        super.log.logf(FQCN, INFO, null, ignoreXmlAttribute$str(), attribute);
    }
    protected String ignoreXmlAttribute$str() {
        return "ISPN000293: Ignoring XML attribute %s, please remove from configuration file";
    }
    protected String couldNotMigrateData$str() {
        return "ISPN000397: Could not migrate data for cache %s, check remote store config in the target cluster. Make sure only one remote store is present and is pointing to the source cluster";
    }
    @Override
    public final CacheException couldNotMigrateData(final String name) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), couldNotMigrateData$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String cannotEnableHotRodWrapping$str() {
        return "ISPN010005: Cannot enable HotRod wrapping if a marshaller and/or an entryWrapper have already been set";
    }
    @Override
    public final CacheConfigurationException cannotEnableHotRodWrapping() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotEnableHotRodWrapping$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String segmentationNotSupportedInThisVersion$str() {
        return "ISPN010008: RemoteStore only supports segmentation when using at least protocol version %s or higher";
    }
    @Override
    public final CacheConfigurationException segmentationNotSupportedInThisVersion(final ProtocolVersion version) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), segmentationNotSupportedInThisVersion$str(), version));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String clusteredRequiresBeingShared$str() {
        return "ISPN010009: A RemoteStore must be shared in a cache that is clustered";
    }
    @Override
    public final CacheConfigurationException clusteredRequiresBeingShared() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), clusteredRequiresBeingShared$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String segmentationRequiresEqualSegments$str() {
        return "ISPN010010: Segmentation is not supported for a RemoteStore when the configured segments %d do not match the remote servers amount %s";
    }
    @Override
    public final CacheConfigurationException segmentationRequiresEqualSegments(final int cacheSegmentCount, final Integer serverSegmentCount) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), segmentationRequiresEqualSegments$str(), cacheSegmentCount, serverSegmentCount));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String segmentationRequiresEqualMediaTypes$str() {
        return "ISPN010011: Segmentation is not supported for a RemoteStore when the configured key media type %s does not match the remote servers key media type %s";
    }
    @Override
    public final CacheConfigurationException segmentationRequiresEqualMediaTypes(final MediaType cacheMediaType, final MediaType serverMediaType) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), segmentationRequiresEqualMediaTypes$str(), cacheMediaType, serverMediaType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String segmentationNotSupportedWithGroups$str() {
        return "ISPN010012: The RemoteCacheStore cannot be segmented when grouping is enabled";
    }
    @Override
    public final CacheConfigurationException segmentationNotSupportedWithGroups() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), segmentationNotSupportedWithGroups$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String remoteStoreWithoutContainer$str() {
        return "ISPN010013: The RemoteCacheStore must specify either an existing remote-cache-container or provide a URI/server list";
    }
    @Override
    public final CacheConfigurationException remoteStoreWithoutContainer() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), remoteStoreWithoutContainer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String shouldUseSameMarshallerWithContainer$str() {
        return "ISPN010014: All stores referencing the same manager must use the same marshaller, actual is %s but provided was %s";
    }
    @Override
    public final CacheConfigurationException shouldUseSameMarshallerWithContainer(final Marshaller inUse, final Marshaller provided) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), shouldUseSameMarshallerWithContainer$str(), inUse, provided));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownRemoteCacheManagerContainer$str() {
        return "ISPN010015: The remote cache container with name '%s' was not found";
    }
    @Override
    public final CacheConfigurationException unknownRemoteCacheManagerContainer(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownRemoteCacheManagerContainer$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
