/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.remote.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.loaders.remote.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.loaders.remote.configuration.ExecutorFactoryConfigurationBuilder;
import org.infinispan.loaders.remote.configuration.RemoteCacheStoreConfiguration;
import org.infinispan.loaders.remote.configuration.RemoteCacheStoreConfigurationChildBuilder;
import org.infinispan.loaders.remote.configuration.RemoteServerConfiguration;
import org.infinispan.loaders.remote.configuration.RemoteServerConfigurationBuilder;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.TypedProperties;

public class RemoteCacheStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<RemoteCacheStoreConfiguration, RemoteCacheStoreConfigurationBuilder>
implements RemoteCacheStoreConfigurationChildBuilder<RemoteCacheStoreConfigurationBuilder> {
    private final ExecutorFactoryConfigurationBuilder asyncExecutorFactory;
    private String balancingStrategy = RoundRobinBalancingStrategy.class.getName();
    private final ConnectionPoolConfigurationBuilder connectionPool;
    private long connectionTimeout = 60000L;
    private boolean forceReturnValues;
    private int keySizeEstimate = 64;
    private String marshaller;
    private boolean pingOnStartup = true;
    private String protocolVersion;
    private String remoteCacheName = "___defaultcache";
    private List<RemoteServerConfigurationBuilder> servers = new ArrayList<RemoteServerConfigurationBuilder>();
    private long socketTimeout = 60000L;
    private boolean tcpNoDelay = true;
    private String transportFactory;
    private int valueSizeEstimate = 512;

    public RemoteCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
        this.asyncExecutorFactory = new ExecutorFactoryConfigurationBuilder(this);
        this.connectionPool = new ConnectionPoolConfigurationBuilder(this);
    }

    public RemoteCacheStoreConfigurationBuilder self() {
        return this;
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    @Override
    public RemoteCacheStoreConfigurationBuilder balancingStrategy(String balancingStrategy) {
        this.balancingStrategy = balancingStrategy;
        return this;
    }

    @Override
    public ConnectionPoolConfigurationBuilder connectionPool() {
        return this.connectionPool;
    }

    @Override
    public RemoteCacheStoreConfigurationBuilder connectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @Override
    public RemoteCacheStoreConfigurationBuilder forceReturnValues(boolean forceReturnValues) {
        this.forceReturnValues = forceReturnValues;
        return this;
    }

    @Override
    public RemoteCacheStoreConfigurationBuilder keySizeEstimate(int keySizeEstimate) {
        this.keySizeEstimate = keySizeEstimate;
        return this;
    }

    @Override
    public RemoteCacheStoreConfigurationBuilder marshaller(String marshaller) {
        this.marshaller = marshaller;
        return this;
    }

    @Override
    public RemoteCacheStoreConfigurationBuilder marshaller(Class<? extends Marshaller> marshaller) {
        this.marshaller = marshaller.getName();
        return this;
    }

    @Override
    public RemoteCacheStoreConfigurationBuilder pingOnStartup(boolean pingOnStartup) {
        this.pingOnStartup = pingOnStartup;
        return this;
    }

    @Override
    public RemoteCacheStoreConfigurationBuilder protocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
        return this;
    }

    @Override
    public RemoteCacheStoreConfigurationBuilder remoteCacheName(String remoteCacheName) {
        this.remoteCacheName = remoteCacheName;
        return this;
    }

    @Override
    public RemoteCacheStoreConfigurationBuilder socketTimeout(long socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @Override
    public RemoteCacheStoreConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    @Override
    public RemoteCacheStoreConfigurationBuilder transportFactory(String transportFactory) {
        this.transportFactory = transportFactory;
        return this;
    }

    @Override
    public RemoteCacheStoreConfigurationBuilder transportFactory(Class<? extends TransportFactory> transportFactory) {
        this.transportFactory = transportFactory.getName();
        return this;
    }

    @Override
    public RemoteCacheStoreConfigurationBuilder valueSizeEstimate(int valueSizeEstimate) {
        this.valueSizeEstimate = valueSizeEstimate;
        return this;
    }

    @Override
    public RemoteServerConfigurationBuilder addServer() {
        RemoteServerConfigurationBuilder builder = new RemoteServerConfigurationBuilder(this);
        this.servers.add(builder);
        return builder;
    }

    public RemoteCacheStoreConfiguration create() {
        ArrayList<RemoteServerConfiguration> remoteServers = new ArrayList<RemoteServerConfiguration>();
        for (RemoteServerConfigurationBuilder server : this.servers) {
            remoteServers.add(server.create());
        }
        return new RemoteCacheStoreConfiguration(this.asyncExecutorFactory.create(), this.balancingStrategy, this.connectionPool.create(), this.connectionTimeout, this.forceReturnValues, this.keySizeEstimate, this.marshaller, this.pingOnStartup, this.protocolVersion, this.remoteCacheName, remoteServers, this.socketTimeout, this.tcpNoDelay, this.transportFactory, this.valueSizeEstimate, this.purgeOnStartup, this.purgeSynchronously, this.purgerThreads, this.fetchPersistentState, this.ignoreModifications, TypedProperties.toTypedProperties((Properties)this.properties), this.async.create(), this.singletonStore.create());
    }

    public RemoteCacheStoreConfigurationBuilder read(RemoteCacheStoreConfiguration template) {
        this.asyncExecutorFactory.read(template.asyncExecutorFactory());
        this.balancingStrategy = template.balancingStrategy();
        this.connectionPool.read(template.connectionPool());
        this.connectionTimeout = template.connectionTimeout();
        this.forceReturnValues = template.forceReturnValues();
        this.keySizeEstimate = template.keySizeEstimate();
        this.marshaller = template.marshaller();
        this.pingOnStartup = template.pingOnStartup();
        this.protocolVersion = template.protocolVersion();
        this.remoteCacheName = template.remoteCacheName();
        this.socketTimeout = template.socketTimeout();
        this.tcpNoDelay = template.tcpNoDelay();
        this.transportFactory = template.transportFactory();
        this.valueSizeEstimate = template.valueSizeEstimate();
        for (RemoteServerConfiguration server : template.servers()) {
            this.addServer().host(server.host()).port(server.port());
        }
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.purgeSynchronously = template.purgeSynchronously();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return this;
    }
}

