/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote;

import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.TimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.RemoteStoreTest", groups={"functional"})
public class RemoteStoreTest
extends BaseStoreTest {
    private static final String REMOTE_CACHE = "remote-cache";
    private EmbeddedCacheManager localCacheManager;
    private HotRodServer hrServer;

    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder localBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        localBuilder.eviction().maxEntries(100).strategy(EvictionStrategy.UNORDERED).expiration().wakeUpInterval(10L);
        GlobalConfigurationBuilder globalConfig = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalConfig.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true));
        this.localCacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globalConfig, (ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)localBuilder));
        this.localCacheManager.getCache(REMOTE_CACHE);
        GlobalComponentRegistry gcr = this.localCacheManager.getGlobalComponentRegistry();
        gcr.registerComponent((Object)this.timeService, TimeService.class);
        gcr.rewire();
        this.localCacheManager.getCache(REMOTE_CACHE).getAdvancedCache().getComponentRegistry().rewire();
        this.hrServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.localCacheManager);
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        RemoteStoreConfigurationBuilder storeConfigurationBuilder = ((RemoteStoreConfigurationBuilder)builder.persistence().addStore(RemoteStoreConfigurationBuilder.class)).remoteCacheName(REMOTE_CACHE);
        storeConfigurationBuilder.addServer().host(this.hrServer.getHost()).port(this.hrServer.getPort());
        RemoteStore remoteStore = new RemoteStore();
        remoteStore.init(this.createContext(builder.build()));
        return remoteStore;
    }

    protected StreamingMarshaller getMarshaller() {
        return this.localCacheManager.getCache("dummy").getAdvancedCache().getComponentRegistry().getCacheMarshaller();
    }

    @AfterMethod
    public void tearDown() {
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hrServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.localCacheManager});
    }

    protected boolean storePurgesAllExpired() {
        return false;
    }

    public void testReplaceExpiredEntry() throws Exception {
        this.cl.write(this.marshalledEntry(this.internalCacheEntry("k1", "v1", 100L)));
        this.timeService.advance(1101L);
        AssertJUnit.assertNull((Object)this.cl.load((Object)"k1"));
        long start = System.currentTimeMillis();
        this.cl.write(this.marshalledEntry(this.internalCacheEntry("k1", "v2", 100L)));
        AssertJUnit.assertTrue((this.cl.load((Object)"k1").getValue().equals("v2") || TestingUtil.moreThanDurationElapsed((long)start, (long)100L) ? 1 : 0) != 0);
    }
}

