/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.commons.util.Util;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedTask;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.logging.Log;
import org.infinispan.persistence.remote.upgrade.HotRodMigratorHelper;
import org.infinispan.persistence.remote.upgrade.MigrationMarshaller;
import org.infinispan.persistence.remote.upgrade.MigrationTask;
import org.infinispan.remoting.transport.Address;
import org.infinispan.upgrade.TargetMigrator;
import org.infinispan.util.logging.LogFactory;

public class HotRodTargetMigrator
implements TargetMigrator {
    private static final Log log = (Log)LogFactory.getLog(HotRodTargetMigrator.class, Log.class);

    public String getName() {
        return "hotrod";
    }

    public long synchronizeData(Cache<Object, Object> cache) throws CacheException {
        return this.synchronizeData(cache, 10000, ProcessorInfo.availableProcessors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long synchronizeData(Cache<Object, Object> cache, int readBatch, int threads) throws CacheException {
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        ClassWhiteList whiteList = cache.getCacheManager().getClassWhiteList();
        PersistenceManager loaderManager = (PersistenceManager)cr.getComponent(PersistenceManager.class);
        Set stores = loaderManager.getStores(RemoteStore.class);
        if (stores.size() != 1) {
            throw log.couldNotMigrateData(cache.getName());
        }
        MigrationMarshaller marshaller = new MigrationMarshaller(whiteList);
        RemoteStore store = (RemoteStore)stores.iterator().next();
        RemoteCache<Object, Object> remoteSourceCache = store.getRemoteCache();
        if (!HotRodMigratorHelper.supportsIteration(store.getConfiguration().protocolVersion())) {
            byte[] knownKeys;
            try {
                knownKeys = marshaller.objectToByteBuffer("___MigrationManager_HotRod_KnownKeys___");
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
            if (remoteSourceCache.containsKey((Object)knownKeys)) {
                Set keys;
                RemoteStoreConfiguration storeConfig = store.getConfiguration();
                if (!storeConfig.hotRodWrapping()) {
                    throw log.remoteStoreNoHotRodWrapping(cache.getName());
                }
                try {
                    keys = (Set)marshaller.objectFromByteBuffer((byte[])remoteSourceCache.get((Object)knownKeys));
                }
                catch (Exception e) {
                    throw new CacheException((Throwable)e);
                }
                ExecutorService es = Executors.newFixedThreadPool(threads);
                AtomicInteger count = new AtomicInteger(0);
                for (Object okey : keys) {
                    byte[] key = (byte[])okey;
                    es.submit(() -> {
                        try {
                            cache.get((Object)key);
                            int i = count.getAndIncrement();
                            if (log.isDebugEnabled() && i % 100 == 0) {
                                log.debugf(">>    Moved %s keys\n", i);
                            }
                        }
                        catch (Exception e) {
                            log.keyMigrationFailed(Util.toStr((Object)key), e);
                        }
                    });
                }
                HotRodMigratorHelper.awaitTermination(es);
                return count.longValue();
            }
            throw log.missingMigrationData(cache.getName());
        }
        DefaultExecutorService executor = new DefaultExecutorService(cache);
        try {
            CacheTopologyInfo sourceCacheTopologyInfo = remoteSourceCache.getCacheTopologyInfo();
            if (sourceCacheTopologyInfo.getSegmentsPerServer().size() == 1) {
                long keys = this.migrateFromSingleServer(cache, readBatch, threads);
                return keys;
            }
            int sourceSegments = sourceCacheTopologyInfo.getNumSegments();
            List targetServers = cache.getAdvancedCache().getDistributionManager().getWriteConsistentHash().getMembers();
            List<List<Integer>> partitions = HotRodMigratorHelper.split(HotRodMigratorHelper.range(sourceSegments), targetServers.size());
            Iterator iterator = targetServers.iterator();
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(targetServers.size());
            for (List<Integer> partition : partitions) {
                HashSet<Integer> segmentSet = new HashSet<Integer>();
                segmentSet.addAll(partition);
                DistributedTask task = executor.createDistributedTaskBuilder((Callable)((Object)new MigrationTask(segmentSet, readBatch, threads))).timeout(Long.MAX_VALUE, TimeUnit.NANOSECONDS).build();
                futures.add(executor.submit((Address)iterator.next(), task));
            }
            long l = futures.stream().mapToInt(f -> {
                try {
                    return (Integer)f.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw log.couldNotMigrateData(cache.getName());
                }
                catch (ExecutionException e) {
                    throw new CacheException((Throwable)e);
                }
            }).sum();
            return l;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private long migrateFromSingleServer(Cache<Object, Object> cache, int readBatch, int threads) {
        MigrationTask migrationTask = new MigrationTask(null, readBatch, threads);
        migrationTask.setEnvironment(cache, null);
        try {
            return migrationTask.call().intValue();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void disconnectSource(Cache<Object, Object> cache) throws CacheException {
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        PersistenceManager loaderManager = (PersistenceManager)cr.getComponent(PersistenceManager.class);
        loaderManager.disableStore(RemoteStore.class.getName());
    }
}

