/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.infinispan.commons.util.Util;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.loaders.rest.configuration.ConnectionPoolConfiguration;
import org.infinispan.loaders.rest.configuration.RestStoreConfiguration;
import org.infinispan.loaders.rest.logging.Log;
import org.infinispan.loaders.rest.metadata.MetadataHelper;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.InternalMetadataImpl;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.CacheLoaderException;
import org.infinispan.persistence.MarshalledEntryImpl;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.keymappers.MarshallingTwoWayKey2StringMapper;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshalledEntry;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class RestStore
implements AdvancedLoadWriteStore {
    private static final String MAX_IDLE_TIME_SECONDS = "maxIdleTimeSeconds";
    private static final String TIME_TO_LIVE_SECONDS = "timeToLiveSeconds";
    private static final Log log = (Log)LogFactory.getLog(RestStore.class, Log.class);
    private static final DateFormat RFC1123_DATEFORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private volatile RestStoreConfiguration configuration;
    private HttpClient httpClient;
    private InternalEntryFactory iceFactory;
    private MarshallingTwoWayKey2StringMapper key2StringMapper;
    private MultiThreadedHttpConnectionManager connectionManager;
    private String path;
    private MetadataHelper metadataHelper;
    private URLCodec urlCodec = new URLCodec();
    private InitializationContext ctx;

    public void init(InitializationContext initializationContext) {
        this.configuration = (RestStoreConfiguration)initializationContext.getConfiguration();
        this.ctx = initializationContext;
    }

    public void start() {
        if (this.iceFactory == null) {
            this.iceFactory = (InternalEntryFactory)this.ctx.getCache().getAdvancedCache().getComponentRegistry().getComponent(InternalEntryFactory.class);
        }
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        ConnectionPoolConfiguration pool = this.configuration.connectionPool();
        params.setConnectionTimeout(pool.connectionTimeout());
        params.setDefaultMaxConnectionsPerHost(pool.maxConnectionsPerHost());
        params.setMaxTotalConnections(pool.maxTotalConnections());
        if (pool.receiveBufferSize() > 0) {
            params.setReceiveBufferSize(pool.receiveBufferSize());
        }
        if (pool.sendBufferSize() > 0) {
            params.setSendBufferSize(pool.sendBufferSize());
        }
        params.setSoTimeout(pool.socketTimeout());
        params.setTcpNoDelay(pool.tcpNoDelay());
        this.connectionManager.setParams(params);
        this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
        this.httpClient.getHostConfiguration().setHost(this.configuration.host(), this.configuration.port());
        this.key2StringMapper = (MarshallingTwoWayKey2StringMapper)Util.getInstance((String)this.configuration.key2StringMapper(), (ClassLoader)this.ctx.getCache().getAdvancedCache().getClassLoader());
        this.key2StringMapper.setMarshaller(this.ctx.getMarshaller());
        this.path = this.configuration.path();
        try {
            if (this.configuration.appendCacheNameToPath()) {
                this.path = this.path + this.urlCodec.encode(this.ctx.getCache().getName()) + "/";
            }
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
        this.metadataHelper = (MetadataHelper)Util.getInstance((String)this.configuration.metadataHelper(), (ClassLoader)this.ctx.getCache().getAdvancedCache().getClassLoader());
    }

    public void stop() {
        this.connectionManager.shutdown();
    }

    public void setInternalCacheEntryFactory(InternalEntryFactory iceFactory) {
        if (this.iceFactory != null) {
            throw new IllegalStateException();
        }
        this.iceFactory = iceFactory;
    }

    private String keyToUri(Object key) {
        try {
            return this.path + this.urlCodec.encode(this.key2StringMapper.getStringMapping(key));
        }
        catch (EncoderException e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    private byte[] marshall(String contentType, MarshalledEntry entry) throws IOException, InterruptedException {
        if (contentType.startsWith("text/")) {
            return (byte[])entry.getValue();
        }
        return this.ctx.getMarshaller().objectToByteBuffer(entry.getValue());
    }

    private Object unmarshall(String contentType, byte[] b) throws IOException, ClassNotFoundException {
        if (contentType.startsWith("text/")) {
            return new String(b);
        }
        return this.ctx.getMarshaller().objectFromByteBuffer(b);
    }

    public void write(MarshalledEntry entry) {
        PutMethod put = new PutMethod(this.keyToUri(entry.getKey()));
        InternalMetadata metadata = entry.getMetadata();
        if (metadata != null && metadata.expiryTime() > -1L) {
            put.setRequestHeader(TIME_TO_LIVE_SECONDS, Long.toString(this.timeoutToSeconds(metadata.lifespan())));
            put.setRequestHeader(MAX_IDLE_TIME_SECONDS, Long.toString(this.timeoutToSeconds(metadata.maxIdle())));
        }
        try {
            String contentType = this.metadataHelper.getContentType(entry);
            put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(this.marshall(contentType, entry), contentType));
            this.httpClient.executeMethod((HttpMethod)put);
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            put.releaseConnection();
        }
    }

    public void clear() {
        DeleteMethod del = new DeleteMethod(this.path);
        try {
            this.httpClient.executeMethod((HttpMethod)del);
            this.discardBody(del.getResponseBodyAsStream());
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            del.releaseConnection();
        }
    }

    public boolean delete(Object key) {
        DeleteMethod del = new DeleteMethod(this.keyToUri(key));
        try {
            int status = this.httpClient.executeMethod((HttpMethod)del);
            this.discardBody(del.getResponseBodyAsStream());
            boolean bl = this.isSuccessful(status);
            return bl;
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            del.releaseConnection();
        }
    }

    public MarshalledEntry load(Object key) {
        GetMethod get = new GetMethod(this.keyToUri(key));
        try {
            int status = this.httpClient.executeMethod((HttpMethod)get);
            switch (status) {
                case 200: {
                    InternalMetadataImpl internalMetadata;
                    String contentType = get.getResponseHeader("Content-Type").getValue();
                    long ttl = this.timeHeaderToSeconds(get.getResponseHeader(TIME_TO_LIVE_SECONDS));
                    long maxidle = this.timeHeaderToSeconds(get.getResponseHeader(MAX_IDLE_TIME_SECONDS));
                    Metadata metadata = this.metadataHelper.buildMetadata(contentType, ttl, TimeUnit.SECONDS, maxidle, TimeUnit.SECONDS);
                    if (metadata.maxIdle() > -1L || metadata.lifespan() > -1L) {
                        long now = this.ctx.getTimeService().wallClockTime();
                        internalMetadata = new InternalMetadataImpl(metadata, now, now);
                    } else {
                        internalMetadata = new InternalMetadataImpl(metadata, -1L, -1L);
                    }
                    MarshalledEntryImpl marshalledEntryImpl = new MarshalledEntryImpl(key, this.unmarshall(contentType, get.getResponseBody()), (InternalMetadata)internalMetadata, this.ctx.getMarshaller());
                    return marshalledEntryImpl;
                }
                case 404: {
                    MarshalledEntry marshalledEntry = null;
                    return marshalledEntry;
                }
            }
            try {
                throw log.httpError(get.getStatusText());
            }
            catch (IOException e) {
                throw log.httpError(e);
            }
            catch (Exception e) {
                throw new CacheLoaderException((Throwable)e);
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    private long timeoutToSeconds(long timeout) {
        if (timeout < 0L) {
            return -1L;
        }
        if (timeout > 0L && timeout < 1000L) {
            return 1L;
        }
        return TimeUnit.MILLISECONDS.toSeconds(timeout);
    }

    private long timeHeaderToSeconds(Header header) {
        return header == null ? -1L : Long.parseLong(header.getValue());
    }

    public void process(AdvancedCacheLoader.KeyFilter keyFilter, AdvancedCacheLoader.CacheLoaderTask cacheLoaderTask, Executor executor, boolean loadValue, boolean loadMetadata) {
        GetMethod get = new GetMethod(this.path + "?global");
        get.addRequestHeader("Accept", "text/plain");
        try {
            this.httpClient.executeMethod((HttpMethod)get);
            int count = 0;
            int batchSize = 1000;
            ExecutorCompletionService ecs = new ExecutorCompletionService(executor);
            int tasks = 0;
            TaskContextImpl taskContext = new TaskContextImpl();
            BufferedReader reader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), get.getResponseCharSet()));
            HashSet<String> entries = new HashSet<String>(batchSize);
            String key = reader.readLine();
            while (key != null) {
                if (keyFilter == null || keyFilter.shouldLoadKey((Object)key)) {
                    entries.add(key);
                }
                if (entries.size() == batchSize) {
                    HashSet<String> batch = entries;
                    entries = new HashSet(batchSize);
                    this.submitProcessTask(cacheLoaderTask, ecs, (AdvancedCacheLoader.TaskContext)taskContext, batch, loadValue, loadMetadata);
                    ++tasks;
                }
                key = reader.readLine();
                ++count;
            }
            if (!entries.isEmpty()) {
                this.submitProcessTask(cacheLoaderTask, ecs, (AdvancedCacheLoader.TaskContext)taskContext, entries, loadValue, loadMetadata);
                ++tasks;
            }
            PersistenceUtil.waitForAllTasksToComplete(ecs, (int)tasks);
        }
        catch (Exception e) {
            throw log.errorLoadingRemoteEntries(e);
        }
        finally {
            get.releaseConnection();
        }
    }

    private void submitProcessTask(final AdvancedCacheLoader.CacheLoaderTask cacheLoaderTask, ExecutorCompletionService ecs, final AdvancedCacheLoader.TaskContext taskContext, final Set<String> batch, final boolean loadEntry, final boolean loadMetadata) {
        ecs.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (Object key : batch) {
                    if (taskContext.isStopped()) break;
                    if (!loadEntry && !loadMetadata) {
                        cacheLoaderTask.processEntry((MarshalledEntry)new MarshalledEntryImpl(key, (Object)null, null, RestStore.this.ctx.getMarshaller()), taskContext);
                        continue;
                    }
                    cacheLoaderTask.processEntry(RestStore.this.load(key), taskContext);
                }
                return null;
            }
        });
    }

    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener purgeListener) {
    }

    public int size() {
        GetMethod get = new GetMethod(this.path + "?global");
        get.addRequestHeader("Accept", "text/plain");
        try {
            this.httpClient.executeMethod((HttpMethod)get);
            BufferedReader reader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), get.getResponseCharSet()));
            int count = 0;
            while (reader.readLine() != null) {
                ++count;
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw log.errorLoadingRemoteEntries(e);
        }
        finally {
            get.releaseConnection();
        }
    }

    public boolean contains(Object o) {
        return this.load(o) != null;
    }

    private boolean isSuccessful(int status) {
        return status >= 200 && status < 300;
    }

    private void discardBody(InputStream is) throws IOException {
        if (is != null) {
            while (is.read() != -1) {
            }
        }
    }
}

