/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.rest.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    APPEND_CACHE_NAME_TO_PATH("appendCacheNameToPath"),
    CONNECTION_TIMEOUT("connectionTimeout"),
    HOST("host"),
    KEY_TO_STRING_MAPPER("key2StringMapper"),
    MAX_CONNECTIONS_PER_HOST("maxConnectionsPerHost"),
    MAX_TOTAL_CONNECTIONS("maxTotalConnections"),
    PATH("path"),
    PORT("port"),
    RECEIVE_BUFFER_SIZE("receiveBufferSize"),
    SEND_BUFFER_SIZE("sendBufferSize"),
    SOCKET_TIMEOUT("socketTimeout"),
    TCP_NO_DELAY("tcpNoDelay");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

