/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.rest.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.loaders.rest.configuration.AbstractRestStoreConfigurationChildBuilder;
import org.infinispan.loaders.rest.configuration.ConnectionPoolConfiguration;
import org.infinispan.loaders.rest.configuration.RestStoreConfigurationBuilder;

public class ConnectionPoolConfigurationBuilder
extends AbstractRestStoreConfigurationChildBuilder<RestStoreConfigurationBuilder>
implements Builder<ConnectionPoolConfiguration> {
    private int connectionTimeout = 60000;
    private int maxConnectionsPerHost = 4;
    private int maxTotalConnections = 20;
    private int receiveBufferSize;
    private int sendBufferSize;
    private int socketTimeout = 60000;
    private boolean tcpNoDelay = true;

    ConnectionPoolConfigurationBuilder(RestStoreConfigurationBuilder builder) {
        super(builder);
    }

    public ConnectionPoolConfigurationBuilder maxConnectionsPerHost(int maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
        return this;
    }

    public ConnectionPoolConfigurationBuilder connectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public ConnectionPoolConfigurationBuilder receiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
        return this;
    }

    public ConnectionPoolConfigurationBuilder sendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
        return this;
    }

    public ConnectionPoolConfigurationBuilder socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public ConnectionPoolConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public void validate() {
    }

    public ConnectionPoolConfiguration create() {
        return new ConnectionPoolConfiguration(this.connectionTimeout, this.maxConnectionsPerHost, this.maxTotalConnections, this.receiveBufferSize, this.sendBufferSize, this.socketTimeout, this.tcpNoDelay);
    }

    public ConnectionPoolConfigurationBuilder read(ConnectionPoolConfiguration template) {
        this.connectionTimeout = template.connectionTimeout();
        this.maxConnectionsPerHost = template.maxConnectionsPerHost();
        this.maxTotalConnections = template.maxTotalConnections();
        this.receiveBufferSize = template.receiveBufferSize();
        this.sendBufferSize = template.sendBufferSize();
        this.socketTimeout = template.socketTimeout();
        this.tcpNoDelay = template.tcpNoDelay();
        return this;
    }
}

