/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.infinispan.commons.util.Util;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.InternalMetadataImpl;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.CacheLoaderException;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.keymappers.MarshallingTwoWayKey2StringMapper;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.rest.configuration.RestStoreConfiguration;
import org.infinispan.persistence.rest.logging.Log;
import org.infinispan.persistence.rest.metadata.MetadataHelper;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class RestStore
implements AdvancedLoadWriteStore {
    private static final String MAX_IDLE_TIME_SECONDS = "maxIdleTimeSeconds";
    private static final String TIME_TO_LIVE_SECONDS = "timeToLiveSeconds";
    private static final Log log = (Log)LogFactory.getLog(RestStore.class, Log.class);
    private static final DateFormat RFC1123_DATEFORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private volatile RestStoreConfiguration configuration;
    private HttpClient httpClient;
    private InternalEntryFactory iceFactory;
    private MarshallingTwoWayKey2StringMapper key2StringMapper;
    private PoolingClientConnectionManager connectionManager;
    private String path;
    private MetadataHelper metadataHelper;
    private URLCodec urlCodec = new URLCodec();
    private InitializationContext ctx;
    private HttpHost httpHost;

    public void init(InitializationContext initializationContext) {
        this.configuration = (RestStoreConfiguration)initializationContext.getConfiguration();
        this.ctx = initializationContext;
    }

    public void start() {
        if (this.iceFactory == null) {
            this.iceFactory = (InternalEntryFactory)this.ctx.getCache().getAdvancedCache().getComponentRegistry().getComponent(InternalEntryFactory.class);
        }
        this.connectionManager = new PoolingClientConnectionManager();
        ConnectionPoolConfiguration pool = this.configuration.connectionPool();
        this.connectionManager.setDefaultMaxPerRoute(pool.maxConnectionsPerHost());
        this.connectionManager.setMaxTotal(pool.maxTotalConnections());
        BasicHttpParams params = new BasicHttpParams();
        params.setParameter("http.connection.timeout", (Object)pool.connectionTimeout());
        params.setParameter("http.socket.timeout", (Object)pool.socketTimeout());
        params.setParameter("http.tcp.nodelay", (Object)pool.tcpNoDelay());
        params.setParameter("http.socket.buffer-size", (Object)pool.bufferSize());
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)this.connectionManager, (HttpParams)params);
        this.httpHost = new HttpHost(this.configuration.host(), this.configuration.port());
        this.key2StringMapper = (MarshallingTwoWayKey2StringMapper)Util.getInstance((String)this.configuration.key2StringMapper(), (ClassLoader)this.ctx.getCache().getAdvancedCache().getClassLoader());
        this.key2StringMapper.setMarshaller(this.ctx.getMarshaller());
        this.path = this.configuration.path();
        try {
            if (this.configuration.appendCacheNameToPath()) {
                this.path = this.path + this.urlCodec.encode(this.ctx.getCache().getName()) + "/";
            }
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
        this.metadataHelper = (MetadataHelper)Util.getInstance((String)this.configuration.metadataHelper(), (ClassLoader)this.ctx.getCache().getAdvancedCache().getClassLoader());
    }

    public void stop() {
        this.connectionManager.shutdown();
    }

    public void setInternalCacheEntryFactory(InternalEntryFactory iceFactory) {
        if (this.iceFactory != null) {
            throw new IllegalStateException();
        }
        this.iceFactory = iceFactory;
    }

    private String keyToUri(Object key) {
        try {
            return this.path + this.urlCodec.encode(this.key2StringMapper.getStringMapping(key));
        }
        catch (EncoderException e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    private byte[] marshall(String contentType, MarshalledEntry entry) throws IOException, InterruptedException {
        if (contentType.startsWith("text/")) {
            return (byte[])entry.getValue();
        }
        return this.ctx.getMarshaller().objectToByteBuffer(entry.getValue());
    }

    private Object unmarshall(String contentType, byte[] b) throws IOException, ClassNotFoundException {
        if (contentType.startsWith("text/")) {
            return new String(b);
        }
        return this.ctx.getMarshaller().objectFromByteBuffer(b);
    }

    public void write(MarshalledEntry entry) {
        HttpPut put = new HttpPut(this.keyToUri(entry.getKey()));
        InternalMetadata metadata = entry.getMetadata();
        if (metadata != null && metadata.expiryTime() > -1L) {
            put.addHeader(TIME_TO_LIVE_SECONDS, Long.toString(this.timeoutToSeconds(metadata.lifespan())));
            put.addHeader(MAX_IDLE_TIME_SECONDS, Long.toString(this.timeoutToSeconds(metadata.maxIdle())));
        }
        try {
            String contentType = this.metadataHelper.getContentType(entry);
            put.setEntity((HttpEntity)new ByteArrayEntity(this.marshall(contentType, entry), ContentType.create((String)contentType)));
            this.httpClient.execute(this.httpHost, (HttpRequest)put);
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            put.abort();
        }
    }

    public void clear() {
        HttpDelete del = new HttpDelete(this.path);
        try {
            HttpResponse response = this.httpClient.execute(this.httpHost, (HttpRequest)del);
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            del.abort();
        }
    }

    public boolean delete(Object key) {
        HttpDelete del = new HttpDelete(this.keyToUri(key));
        try {
            HttpResponse response = this.httpClient.execute(this.httpHost, (HttpRequest)del);
            EntityUtils.consume((HttpEntity)response.getEntity());
            boolean bl = this.isSuccessful(response.getStatusLine().getStatusCode());
            return bl;
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            del.abort();
        }
    }

    public MarshalledEntry load(Object key) {
        HttpGet get = new HttpGet(this.keyToUri(key));
        try {
            HttpResponse response = this.httpClient.execute(this.httpHost, (HttpRequest)get);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    InternalMetadataImpl internalMetadata;
                    String contentType = response.getFirstHeader("Content-Type").getValue();
                    long ttl = this.timeHeaderToSeconds(response.getFirstHeader(TIME_TO_LIVE_SECONDS));
                    long maxidle = this.timeHeaderToSeconds(response.getFirstHeader(MAX_IDLE_TIME_SECONDS));
                    Metadata metadata = this.metadataHelper.buildMetadata(contentType, ttl, TimeUnit.SECONDS, maxidle, TimeUnit.SECONDS);
                    if (metadata.maxIdle() > -1L || metadata.lifespan() > -1L) {
                        long now = this.ctx.getTimeService().wallClockTime();
                        internalMetadata = new InternalMetadataImpl(metadata, now, now);
                    } else {
                        internalMetadata = new InternalMetadataImpl(metadata, -1L, -1L);
                    }
                    byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                    MarshalledEntry marshalledEntry = this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, this.unmarshall(contentType, bytes), (InternalMetadata)internalMetadata);
                    return marshalledEntry;
                }
                case 404: {
                    MarshalledEntry marshalledEntry = null;
                    return marshalledEntry;
                }
            }
            try {
                throw log.httpError(response.getStatusLine().toString());
            }
            catch (IOException e) {
                throw log.httpError(e);
            }
            catch (Exception e) {
                throw new CacheLoaderException((Throwable)e);
            }
        }
        finally {
            get.abort();
        }
    }

    private long timeoutToSeconds(long timeout) {
        if (timeout < 0L) {
            return -1L;
        }
        if (timeout > 0L && timeout < 1000L) {
            return 1L;
        }
        return TimeUnit.MILLISECONDS.toSeconds(timeout);
    }

    private long timeHeaderToSeconds(Header header) {
        return header == null ? -1L : Long.parseLong(header.getValue());
    }

    public void process(AdvancedCacheLoader.KeyFilter keyFilter, AdvancedCacheLoader.CacheLoaderTask cacheLoaderTask, Executor executor, boolean loadValue, boolean loadMetadata) {
        HttpGet get = new HttpGet(this.path + "?global");
        get.addHeader("Accept", "text/plain");
        try {
            HttpResponse response = this.httpClient.execute(this.httpHost, (HttpRequest)get);
            HttpEntity entity = response.getEntity();
            int batchSize = 1000;
            ExecutorCompletionService ecs = new ExecutorCompletionService(executor);
            int tasks = 0;
            TaskContextImpl taskContext = new TaskContextImpl();
            BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
            HashSet<Object> entries = new HashSet<Object>(batchSize);
            String stringKey = reader.readLine();
            while (stringKey != null) {
                Object key = this.key2StringMapper.getKeyMapping(stringKey);
                if (keyFilter == null || keyFilter.shouldLoadKey(key)) {
                    entries.add(key);
                }
                if (entries.size() == batchSize) {
                    HashSet<Object> batch = entries;
                    entries = new HashSet(batchSize);
                    this.submitProcessTask(cacheLoaderTask, ecs, (AdvancedCacheLoader.TaskContext)taskContext, batch, loadValue, loadMetadata);
                    ++tasks;
                }
                stringKey = reader.readLine();
            }
            if (!entries.isEmpty()) {
                this.submitProcessTask(cacheLoaderTask, ecs, (AdvancedCacheLoader.TaskContext)taskContext, entries, loadValue, loadMetadata);
                ++tasks;
            }
            PersistenceUtil.waitForAllTasksToComplete(ecs, (int)tasks);
        }
        catch (Exception e) {
            throw log.errorLoadingRemoteEntries(e);
        }
        finally {
            get.releaseConnection();
        }
    }

    private void submitProcessTask(final AdvancedCacheLoader.CacheLoaderTask cacheLoaderTask, ExecutorCompletionService ecs, final AdvancedCacheLoader.TaskContext taskContext, final Set<Object> batch, final boolean loadEntry, final boolean loadMetadata) {
        ecs.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (Object key : batch) {
                    if (taskContext.isStopped()) break;
                    if (!loadEntry && !loadMetadata) {
                        cacheLoaderTask.processEntry(RestStore.this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, (Object)null, null), taskContext);
                        continue;
                    }
                    cacheLoaderTask.processEntry(RestStore.this.load(key), taskContext);
                }
                return null;
            }
        });
    }

    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener purgeListener) {
    }

    public int size() {
        HttpGet get = new HttpGet(this.path + "?global");
        get.addHeader("Accept", "text/plain");
        try {
            HttpResponse response = this.httpClient.execute(this.httpHost, (HttpRequest)get);
            HttpEntity entity = response.getEntity();
            BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
            int count = 0;
            while (reader.readLine() != null) {
                ++count;
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw log.errorLoadingRemoteEntries(e);
        }
        finally {
            get.releaseConnection();
        }
    }

    public boolean contains(Object o) {
        return this.load(o) != null;
    }

    private boolean isSuccessful(int status) {
        return status >= 200 && status < 300;
    }
}

