/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser70;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.rest.configuration.Attribute;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.rest.configuration.Element;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationBuilder;
import org.infinispan.persistence.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(uri="urn:infinispan:config:store:rest:7.0", root="rest-store"), @Namespace(root="rest-store")})
public class RestStoreConfigurationParser70
implements ConfigurationParser {
    private static final Log log = (Log)LogFactory.getLog(RestStoreConfigurationParser70.class, Log.class);

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case REST_STORE: {
                this.parseRestStore(reader, builder.persistence());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseRestStore(XMLExtendedStreamReader reader, PersistenceConfigurationBuilder loadersBuilder) throws XMLStreamException {
        RestStoreConfigurationBuilder builder = new RestStoreConfigurationBuilder(loadersBuilder);
        this.parseRestStoreAttributes(reader, builder);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTION_POOL: {
                    this.parseConnectionPool(reader, builder.connectionPool());
                    continue block4;
                }
                case SERVER: {
                    this.parseServer(reader, builder);
                    continue block4;
                }
            }
            Parser70.parseStoreElement((XMLExtendedStreamReader)reader, (StoreConfigurationBuilder)builder);
        }
        loadersBuilder.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseServer(XMLExtendedStreamReader reader, RestStoreConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    builder.host(value);
                    continue block5;
                }
                case PORT: {
                    builder.port(Integer.parseInt(value));
                    continue block5;
                }
                case OUTBOUND_SOCKET_BINDING: {
                    log.ignoreXmlAttribute((Object)attribute);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseConnectionPool(XMLExtendedStreamReader reader, ConnectionPoolConfigurationBuilder builder) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONNECTION_TIMEOUT: {
                    builder.connectionTimeout(Integer.parseInt(value));
                    continue block8;
                }
                case MAX_CONNECTIONS_PER_HOST: {
                    builder.maxConnectionsPerHost(Integer.parseInt(value));
                    continue block8;
                }
                case MAX_TOTAL_CONNECTIONS: {
                    builder.maxTotalConnections(Integer.parseInt(value));
                    continue block8;
                }
                case BUFFER_SIZE: {
                    builder.bufferSize(Integer.parseInt(value));
                    continue block8;
                }
                case SOCKET_TIMEOUT: {
                    builder.socketTimeout(Integer.parseInt(value));
                    continue block8;
                }
                case TCP_NO_DELAY: {
                    builder.tcpNoDelay(Boolean.parseBoolean(value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseRestStoreAttributes(XMLExtendedStreamReader reader, RestStoreConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            String attributeName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attributeName);
            switch (attribute) {
                case APPEND_CACHE_NAME_TO_PATH: {
                    builder.appendCacheNameToPath(Boolean.parseBoolean(value));
                    continue block5;
                }
                case PATH: {
                    builder.path(value);
                    continue block5;
                }
                case KEY_TO_STRING_MAPPER: {
                    builder.key2StringMapper(value);
                    continue block5;
                }
                default: {
                    Parser70.parseStoreAttribute((XMLExtendedStreamReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
                }
            }
        }
    }
}

