/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.persistence.rest.configuration.AbstractRestStoreConfigurationChildBuilder;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationBuilder;

public class ConnectionPoolConfigurationBuilder
extends AbstractRestStoreConfigurationChildBuilder<RestStoreConfigurationBuilder>
implements Builder<ConnectionPoolConfiguration> {
    private int connectionTimeout = 60000;
    private int maxConnectionsPerHost = 4;
    private int maxTotalConnections = 20;
    private int bufferSize = 8192;
    private int socketTimeout = 60000;
    private boolean tcpNoDelay = true;

    ConnectionPoolConfigurationBuilder(RestStoreConfigurationBuilder builder) {
        super(builder);
    }

    public ConnectionPoolConfigurationBuilder maxConnectionsPerHost(int maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
        return this;
    }

    public ConnectionPoolConfigurationBuilder connectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public ConnectionPoolConfigurationBuilder bufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public ConnectionPoolConfigurationBuilder socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public ConnectionPoolConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public void validate() {
    }

    public ConnectionPoolConfiguration create() {
        return new ConnectionPoolConfiguration(this.connectionTimeout, this.maxConnectionsPerHost, this.maxTotalConnections, this.bufferSize, this.socketTimeout, this.tcpNoDelay);
    }

    public ConnectionPoolConfigurationBuilder read(ConnectionPoolConfiguration template) {
        this.connectionTimeout = template.connectionTimeout();
        this.maxConnectionsPerHost = template.maxConnectionsPerHost();
        this.maxTotalConnections = template.maxTotalConnections();
        this.bufferSize = template.bufferSize();
        this.socketTimeout = template.socketTimeout();
        this.tcpNoDelay = template.tcpNoDelay();
        return this;
    }
}

