/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

public class ConnectionPoolConfiguration {
    private final int connectionTimeout;
    private final int maxConnectionsPerHost;
    private final int maxTotalConnections;
    private final int bufferSize;
    private final int socketTimeout;
    private final boolean tcpNoDelay;

    ConnectionPoolConfiguration(int connectionTimeout, int maxConnectionsPerHost, int maxTotalConnections, int bufferSize, int socketTimeout, boolean tcpNoDelay) {
        this.connectionTimeout = connectionTimeout;
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        this.maxTotalConnections = maxTotalConnections;
        this.bufferSize = bufferSize;
        this.socketTimeout = socketTimeout;
        this.tcpNoDelay = tcpNoDelay;
    }

    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    public int maxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public int maxTotalConnections() {
        return this.maxTotalConnections;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public int socketTimeout() {
        return this.socketTimeout;
    }

    public boolean tcpNoDelay() {
        return this.tcpNoDelay;
    }

    public String toString() {
        return "ConnectionPoolConfiguration [connectionTimeout=" + this.connectionTimeout + ", maxConnectionsPerHost=" + this.maxConnectionsPerHost + ", maxTotalConnections=" + this.maxTotalConnections + ", bufferSize=" + this.bufferSize + ", socketTimeout=" + this.socketTimeout + ", tcpNoDelay=" + this.tcpNoDelay + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionPoolConfiguration that = (ConnectionPoolConfiguration)o;
        if (this.connectionTimeout != that.connectionTimeout) {
            return false;
        }
        if (this.maxConnectionsPerHost != that.maxConnectionsPerHost) {
            return false;
        }
        if (this.maxTotalConnections != that.maxTotalConnections) {
            return false;
        }
        if (this.bufferSize != that.bufferSize) {
            return false;
        }
        if (this.socketTimeout != that.socketTimeout) {
            return false;
        }
        return this.tcpNoDelay == that.tcpNoDelay;
    }

    public int hashCode() {
        int result = this.connectionTimeout;
        result = 31 * result + this.maxConnectionsPerHost;
        result = 31 * result + this.maxTotalConnections;
        result = 31 * result + this.bufferSize;
        result = 31 * result + this.socketTimeout;
        result = 31 * result + (this.tcpNoDelay ? 1 : 0);
        return result;
    }
}

