/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    COMPRESSION("compression"),
    EXPIRATION("expiration"),
    ROCKSDB_STORE("rocksdb-store");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>(Element.values().length);
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

