/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb;

import io.reactivex.Flowable;
import io.reactivex.internal.functions.Functions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.marshall.persistence.impl.MarshallableEntryImpl;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.rocksdb.PersistenceContextInitializerImpl;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfiguration;
import org.infinispan.persistence.rocksdb.logging.Log;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.MarshalledValue;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.reactive.RxJavaInterop;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.rxjava.FlowableFromIntSetFunction;
import org.reactivestreams.Publisher;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

@Store
@ConfiguredBy(value=RocksDBStoreConfiguration.class)
public class RocksDBStore<K, V>
implements SegmentedAdvancedLoadWriteStore<K, V> {
    private static final Log log = (Log)LogFactory.getLog(RocksDBStore.class, Log.class);
    static final String DATABASE_PROPERTY_NAME_WITH_SUFFIX = "database.";
    static final String COLUMN_FAMILY_PROPERTY_NAME_WITH_SUFFIX = "data.";
    protected RocksDBStoreConfiguration configuration;
    private RocksDB db;
    private RocksDB expiredDb;
    private InitializationContext ctx;
    private TimeService timeService;
    private Semaphore semaphore;
    private WriteOptions dataWriteOptions;
    private RocksDBHandler handler;
    private Properties databaseProperties;
    private Properties columnFamilyProperties;
    private Marshaller marshaller;
    private MarshallableEntryFactory<K, V> entryFactory;
    private volatile boolean stopped = true;

    public void init(InitializationContext ctx) {
        this.configuration = (RocksDBStoreConfiguration)ctx.getConfiguration();
        this.ctx = ctx;
        this.timeService = ctx.getTimeService();
        this.marshaller = ctx.getPersistenceMarshaller();
        this.semaphore = new Semaphore(Integer.MAX_VALUE, true);
        this.entryFactory = ctx.getMarshallableEntryFactory();
        ctx.getPersistenceMarshaller().register((SerializationContextInitializer)new PersistenceContextInitializerImpl());
    }

    public void start() {
        AdvancedCache cache = this.ctx.getCache().getAdvancedCache();
        KeyPartitioner keyPartitioner = (KeyPartitioner)cache.getComponentRegistry().getComponent(KeyPartitioner.class);
        this.handler = this.configuration.segmented() ? new SegmentedRocksDBHandler(cache.getCacheConfiguration().clustering().hash().numSegments(), keyPartitioner) : new NonSegmentedRocksDBHandler(keyPartitioner);
        Properties allProperties = this.configuration.properties();
        for (Map.Entry<Object, Object> entry : allProperties.entrySet()) {
            String key = entry.getKey().toString();
            if (key.startsWith(DATABASE_PROPERTY_NAME_WITH_SUFFIX)) {
                if (this.databaseProperties == null) {
                    this.databaseProperties = new Properties();
                }
                this.databaseProperties.setProperty(key.substring(DATABASE_PROPERTY_NAME_WITH_SUFFIX.length()), entry.getValue().toString());
                continue;
            }
            if (!key.startsWith(COLUMN_FAMILY_PROPERTY_NAME_WITH_SUFFIX)) continue;
            if (this.columnFamilyProperties == null) {
                this.columnFamilyProperties = new Properties();
            }
            this.columnFamilyProperties.setProperty(key.substring(COLUMN_FAMILY_PROPERTY_NAME_WITH_SUFFIX.length()), entry.getValue().toString());
        }
        try {
            this.db = this.handler.open(this.getLocation(), this.dataDbOptions());
            this.expiredDb = this.openDatabase(this.getExpirationLocation(), this.expiredDbOptions());
            this.stopped = false;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Unable to open database", (Throwable)e);
        }
    }

    private Path getLocation() {
        return PersistenceUtil.getQualifiedLocation((GlobalConfiguration)this.ctx.getGlobalConfiguration(), (String)this.configuration.location(), (String)this.ctx.getCache().getName(), (String)"data");
    }

    private Path getExpirationLocation() {
        return PersistenceUtil.getQualifiedLocation((GlobalConfiguration)this.ctx.getGlobalConfiguration(), (String)this.configuration.expiredLocation(), (String)this.ctx.getCache().getName(), (String)"expired");
    }

    private WriteOptions dataWriteOptions() {
        if (this.dataWriteOptions == null) {
            this.dataWriteOptions = new WriteOptions().setDisableWAL(false);
        }
        return this.dataWriteOptions;
    }

    protected DBOptions dataDbOptions() {
        DBOptions dbOptions;
        if (this.databaseProperties != null) {
            dbOptions = DBOptions.getDBOptionsFromProps((Properties)this.databaseProperties);
            if (dbOptions == null) {
                throw log.rocksDBUnknownPropertiesSupplied(this.databaseProperties.toString());
            }
        } else {
            dbOptions = new DBOptions();
        }
        return dbOptions.setCreateIfMissing(true).setCreateMissingColumnFamilies(true);
    }

    protected Options expiredDbOptions() {
        return new Options().setCreateIfMissing(true).setComparator(BuiltinComparator.BYTEWISE_COMPARATOR);
    }

    protected RocksDB openDatabase(Path location, Options options) throws RocksDBException {
        File dir = location.toFile();
        dir.mkdirs();
        return RocksDB.open((Options)options, (String)location.toString());
    }

    public void stop() {
        try {
            this.semaphore.acquire(Integer.MAX_VALUE);
        }
        catch (InterruptedException e) {
            throw new PersistenceException("Cannot acquire semaphore", (Throwable)e);
        }
        try {
            this.handler.close();
            this.expiredDb.close();
        }
        finally {
            this.stopped = true;
            this.semaphore.release(Integer.MAX_VALUE);
        }
    }

    public void destroy() {
        this.stop();
        Util.recursiveFileRemove((File)this.getLocation().toFile());
        Util.recursiveFileRemove((File)this.getExpirationLocation().toFile());
    }

    public boolean isAvailable() {
        return this.getLocation().toFile().exists() && this.getExpirationLocation().toFile().exists();
    }

    public void clear() {
        this.handler.clear(null);
    }

    public void clear(IntSet segments) {
        this.handler.clear(segments);
    }

    public int size() {
        return this.handler.size(null);
    }

    public int size(IntSet segments) {
        return this.handler.size(segments);
    }

    public boolean contains(Object key) {
        return this.handler.contains(-1, key);
    }

    public boolean contains(int segment, Object key) {
        return this.handler.contains(segment, key);
    }

    public Publisher<K> publishKeys(Predicate<? super K> filter) {
        return this.handler.publishKeys(null, filter);
    }

    public Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        return this.handler.publishKeys(segments, filter);
    }

    public Publisher<MarshallableEntry<K, V>> entryPublisher(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        return this.handler.publishEntries(null, filter, fetchValue, fetchMetadata);
    }

    public Publisher<MarshallableEntry<K, V>> entryPublisher(IntSet segments, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        return this.handler.publishEntries(segments, filter, fetchValue, fetchMetadata);
    }

    public boolean delete(Object key) {
        return this.handler.delete(-1, key);
    }

    public boolean delete(int segment, Object key) {
        return this.handler.delete(segment, key);
    }

    public void write(MarshallableEntry entry) {
        this.handler.write(-1, entry);
    }

    public void write(int segment, MarshallableEntry<? extends K, ? extends V> entry) {
        this.handler.write(segment, entry);
    }

    public MarshallableEntry loadEntry(Object key) {
        return this.handler.load(-1, key);
    }

    public MarshallableEntry<K, V> get(int segment, Object key) {
        return this.handler.load(segment, key);
    }

    public CompletionStage<Void> bulkUpdate(Publisher<MarshallableEntry<? extends K, ? extends V>> publisher) {
        return this.handler.writeBatch(publisher);
    }

    public void deleteBatch(Iterable<Object> keys) {
        this.handler.deleteBatch(keys);
    }

    private void putExpireDbData(ExpiryEntry entry) throws InterruptedException, RocksDBException, IOException, ClassNotFoundException {
        byte[] expiryBytes = this.marshall(entry.expiry);
        byte[] existingBytes = this.expiredDb.get(expiryBytes);
        if (existingBytes != null) {
            Object existing = this.unmarshall(existingBytes);
            if (existing instanceof ExpiryBucket) {
                ((ExpiryBucket)existing).entries.add(entry.keyBytes);
                this.expiredDb.put(expiryBytes, this.marshall(existing));
            } else {
                ExpiryBucket bucket = new ExpiryBucket(existingBytes, entry.keyBytes);
                this.expiredDb.put(expiryBytes, this.marshall(bucket));
            }
        } else {
            this.expiredDb.put(expiryBytes, entry.keyBytes);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener purgeListener) {
        block35: {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new PersistenceException("Cannot acquire semaphore: CacheStore is likely stopped.", (Throwable)e);
            }
            try (ReadOptions readOptions = new ReadOptions().setFillCache(false);){
                if (this.stopped) {
                    throw new PersistenceException("RocksDB is stopped");
                }
                long now = this.ctx.getTimeService().wallClockTime();
                RocksIterator iterator = this.expiredDb.newIterator(readOptions);
                if (iterator == null) break block35;
                try (RocksIterator it = iterator;){
                    void var12_23;
                    Object key;
                    Object time;
                    ArrayList<Object> times = new ArrayList<Object>();
                    ArrayList<Object> keys = new ArrayList<Object>();
                    ArrayList<byte[]> marshalledKeys = new ArrayList<byte[]>();
                    it.seekToFirst();
                    while (it.isValid() && (Long)(time = (Long)this.unmarshall(it.key())) <= now) {
                        times.add(time);
                        byte[] byArray = it.value();
                        key = this.unmarshall(byArray);
                        if (key instanceof ExpiryBucket) {
                            for (byte[] bytes : ((ExpiryBucket)key).entries) {
                                marshalledKeys.add(bytes);
                                keys.add(this.unmarshall(bytes));
                            }
                        } else {
                            keys.add(key);
                            marshalledKeys.add(byArray);
                        }
                        it.next();
                    }
                    for (Long l : times) {
                        this.expiredDb.delete(this.marshall(l));
                    }
                    if (!keys.isEmpty()) {
                        log.debugf("purge (up to) %d entries", keys.size());
                    }
                    int count = 0;
                    boolean bl = false;
                    while (var12_23 < keys.size()) {
                        Metadata metadata;
                        MarshalledValue mv;
                        key = keys.get((int)var12_23);
                        byte[] keyBytes = (byte[])marshalledKeys.get((int)var12_23);
                        int segment = this.handler.calculateSegment(key);
                        ColumnFamilyHandle handle = this.handler.getHandle(segment);
                        byte[] valueBytes = this.db.get(handle, keyBytes);
                        if (valueBytes != null && (mv = (MarshalledValue)this.unmarshall(valueBytes)) != null && MarshallableEntryImpl.isExpired((Metadata)(metadata = (Metadata)this.unmarshall(MarshallUtil.toByteArray((ByteBuffer)mv.getMetadataBytes()))), (long)now, (long)mv.getCreated(), (long)mv.getLastUsed())) {
                            this.db.delete(handle, keyBytes);
                            purgeListener.entryPurged(key);
                            ++count;
                        }
                        ++var12_23;
                    }
                    if (count != 0) {
                        log.debugf("purged %d entries", count);
                    }
                }
                catch (Exception e) {
                    throw new PersistenceException((Throwable)e);
                }
                finally {
                    readOptions.close();
                }
            }
            catch (PersistenceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
            finally {
                this.semaphore.release();
            }
        }
    }

    public void addSegments(IntSet segments) {
        this.handler.addSegments(segments);
    }

    public void removeSegments(IntSet segments) {
        this.handler.removeSegments(segments);
    }

    private byte[] marshall(Object entry) throws IOException, InterruptedException {
        return this.marshaller.objectToByteBuffer(entry);
    }

    private Object unmarshall(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        return this.marshaller.objectFromByteBuffer(bytes);
    }

    private MarshallableEntry<K, V> valueToMarshallableEntry(Object key, byte[] valueBytes, boolean fetchMeta) throws IOException, ClassNotFoundException {
        MarshalledValue value = (MarshalledValue)this.unmarshall(valueBytes);
        if (value == null) {
            return null;
        }
        ByteBuffer metadataBytes = fetchMeta ? value.getMetadataBytes() : null;
        return this.entryFactory.create(key, value.getValueBytes(), metadataBytes, value.getCreated(), value.getLastUsed());
    }

    private void addNewExpiry(MarshallableEntry entry) throws RocksDBException, IOException, ClassNotFoundException {
        long expiry = entry.expiryTime();
        long maxIdle = entry.getMetadata().maxIdle();
        if (maxIdle > 0L) {
            expiry = maxIdle + this.ctx.getTimeService().wallClockTime();
        }
        try {
            byte[] keyBytes = entry.getKeyBytes().copy().getBuf();
            this.putExpireDbData(new ExpiryEntry(expiry, keyBytes));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private class SegmentedRocksDBHandler
    extends RocksDBHandler {
        private final KeyPartitioner keyPartitioner;
        private final AtomicReferenceArray<ColumnFamilyHandle> handles;

        private SegmentedRocksDBHandler(int segmentCount, KeyPartitioner keyPartitioner) {
            this.keyPartitioner = keyPartitioner;
            this.handles = new AtomicReferenceArray(segmentCount);
        }

        byte[] byteArrayFromInt(int val) {
            return new byte[]{(byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
        }

        @Override
        ColumnFamilyHandle getHandle(int segment) {
            return this.handles.get(segment);
        }

        @Override
        int calculateSegment(Object key) {
            return this.keyPartitioner.getSegment(key);
        }

        @Override
        RocksDB open(Path location, DBOptions options) throws RocksDBException {
            File dir = location.toFile();
            dir.mkdirs();
            int segmentCount = this.handles.length();
            ArrayList<ColumnFamilyDescriptor> descriptors = new ArrayList<ColumnFamilyDescriptor>(segmentCount + 1);
            ArrayList outHandles = new ArrayList(segmentCount + 1);
            descriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, new ColumnFamilyOptions()));
            for (int i = 0; i < segmentCount; ++i) {
                descriptors.add(this.newDescriptor(this.byteArrayFromInt(i)));
            }
            RocksDB rocksDB = RocksDB.open((DBOptions)options, (String)location.toString(), descriptors, outHandles);
            for (int i = 0; i < segmentCount; ++i) {
                this.handles.set(i, (ColumnFamilyHandle)outHandles.get(i + 1));
            }
            return rocksDB;
        }

        @Override
        void clear(IntSet segments) {
            if (segments != null) {
                PrimitiveIterator.OfInt segmentIterator = segments.iterator();
                while (segmentIterator.hasNext()) {
                    int segment = segmentIterator.nextInt();
                    if (this.clearForSegment(segment)) continue;
                    this.recreateColumnFamily(segment);
                }
            } else {
                for (int i = 0; i < this.handles.length(); ++i) {
                    if (this.clearForSegment(i)) continue;
                    this.recreateColumnFamily(i);
                }
            }
        }

        /*
         * Exception decompiling
         */
        private boolean clearForSegment(int segment) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 24[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        void close() {
            for (int i = 0; i < this.handles.length(); ++i) {
                ColumnFamilyHandle handle = this.handles.getAndSet(i, null);
                if (handle == null) continue;
                handle.close();
            }
            RocksDBStore.this.db.close();
        }

        private void recreateColumnFamily(int segment) {
            ColumnFamilyHandle handle = this.handles.get(segment);
            if (handle != null) {
                try {
                    RocksDBStore.this.db.dropColumnFamily(handle);
                    handle = RocksDBStore.this.db.createColumnFamily(this.newDescriptor(this.byteArrayFromInt(segment)));
                    this.handles.set(segment, handle);
                }
                catch (RocksDBException e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
        }

        @Override
        Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
            Function function = it -> Flowable.fromIterable(() -> new RocksKeyIterator((RocksIterator)it, filter));
            return this.handleIteratorFunction(function, segments);
        }

        @Override
        Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
            Function function = it -> Flowable.fromIterable(() -> {
                long now = RocksDBStore.this.timeService.wallClockTime();
                return new RocksEntryIterator((RocksIterator)it, filter, fetchValue, fetchMetadata, now);
            });
            return this.handleIteratorFunction(function, segments);
        }

        <R> Publisher<R> handleIteratorFunction(Function<RocksIterator, Flowable<R>> function, IntSet segments) {
            if (segments != null && segments.size() == 1) {
                return this.publish(segments.iterator().nextInt(), function);
            }
            return new FlowableFromIntSetFunction(segments == null ? IntSets.immutableRangeSet((int)this.handles.length()) : segments, i -> this.publish(i, function)).concatMap(Functions.identity());
        }

        @Override
        RocksIterator wrapIterator(RocksDB db, ReadOptions readOptions, int segment) {
            ColumnFamilyHandle handle = this.handles.get(segment);
            if (handle != null) {
                return db.newIterator(handle, readOptions);
            }
            return null;
        }

        @Override
        void addSegments(IntSet segments) {
            PrimitiveIterator.OfInt segmentIterator = segments.iterator();
            while (segmentIterator.hasNext()) {
                int segment = segmentIterator.nextInt();
                ColumnFamilyHandle handle = this.handles.get(segment);
                if (handle != null) continue;
                log.tracef("Creating column family for segment %d", segment);
                byte[] cfName = this.byteArrayFromInt(segment);
                try {
                    handle = RocksDBStore.this.db.createColumnFamily(this.newDescriptor(cfName));
                    this.handles.set(segment, handle);
                }
                catch (RocksDBException e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
        }

        @Override
        void removeSegments(IntSet segments) {
            PrimitiveIterator.OfInt segmentIterator = segments.iterator();
            while (segmentIterator.hasNext()) {
                int segment = segmentIterator.nextInt();
                ColumnFamilyHandle handle = this.handles.getAndSet(segment, null);
                if (handle == null) continue;
                log.tracef("Dropping column family for segment %d", segment);
                try {
                    RocksDBStore.this.db.dropColumnFamily(handle);
                }
                catch (RocksDBException e) {
                    throw new PersistenceException((Throwable)e);
                }
                handle.close();
            }
        }
    }

    private final class NonSegmentedRocksDBHandler
    extends RocksDBHandler {
        private final KeyPartitioner keyPartitioner;
        private ColumnFamilyHandle defaultColumnFamilyHandle;

        public NonSegmentedRocksDBHandler(KeyPartitioner keyPartitioner) {
            this.keyPartitioner = keyPartitioner;
        }

        @Override
        ColumnFamilyHandle getHandle(int segment) {
            return this.defaultColumnFamilyHandle;
        }

        @Override
        int calculateSegment(Object key) {
            return 0;
        }

        @Override
        RocksDB open(Path location, DBOptions options) throws RocksDBException {
            File dir = location.toFile();
            dir.mkdirs();
            ArrayList handles = new ArrayList(1);
            RocksDB rocksDB = RocksDB.open((DBOptions)options, (String)location.toString(), Collections.singletonList(this.newDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY)), handles);
            this.defaultColumnFamilyHandle = (ColumnFamilyHandle)handles.get(0);
            return rocksDB;
        }

        @Override
        void clear(IntSet segments) {
            boolean destroyDatabase;
            block32: {
                long count = 0L;
                destroyDatabase = false;
                try {
                    RocksDBStore.this.semaphore.acquire();
                }
                catch (InterruptedException e) {
                    throw new PersistenceException("Cannot acquire semaphore", (Throwable)e);
                }
                try (ReadOptions readOptions = new ReadOptions().setFillCache(false);){
                    if (RocksDBStore.this.stopped) {
                        throw new PersistenceException("RocksDB is stopped");
                    }
                    RocksIterator optionalIterator = this.wrapIterator(RocksDBStore.this.db, readOptions, -1);
                    if (optionalIterator != null && (RocksDBStore.this.configuration.clearThreshold() > 0 || segments == null)) {
                        try (RocksIterator it = optionalIterator;){
                            it.seekToFirst();
                            while (it.isValid()) {
                                byte[] keyBytes = it.key();
                                if (segments != null) {
                                    Object key = RocksDBStore.this.unmarshall(keyBytes);
                                    if (segments.contains(this.keyPartitioner.getSegment(key))) {
                                        RocksDBStore.this.db.delete(this.defaultColumnFamilyHandle, keyBytes);
                                    }
                                } else {
                                    RocksDBStore.this.db.delete(this.defaultColumnFamilyHandle, keyBytes);
                                    if (++count > (long)RocksDBStore.this.configuration.clearThreshold()) {
                                        destroyDatabase = true;
                                        break block32;
                                    }
                                }
                                it.next();
                            }
                            break block32;
                        }
                        catch (RocksDBException e) {
                            if (segments != null) {
                                throw e;
                            }
                            destroyDatabase = true;
                        }
                        break block32;
                    }
                    destroyDatabase = true;
                }
                catch (Exception e) {
                    throw new PersistenceException((Throwable)e);
                }
                finally {
                    RocksDBStore.this.semaphore.release();
                }
            }
            if (destroyDatabase) {
                try {
                    this.reinitAllDatabases();
                }
                catch (Exception e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
        }

        @Override
        void close() {
            this.defaultColumnFamilyHandle.close();
            RocksDBStore.this.db.close();
        }

        protected void reinitAllDatabases() throws RocksDBException {
            try {
                RocksDBStore.this.semaphore.acquire(Integer.MAX_VALUE);
            }
            catch (InterruptedException e) {
                throw new PersistenceException("Cannot acquire semaphore", (Throwable)e);
            }
            try {
                if (RocksDBStore.this.stopped) {
                    throw new PersistenceException("RocksDB is stopped");
                }
                RocksDBStore.this.db.close();
                RocksDBStore.this.expiredDb.close();
                if (System.getProperty("os.name").startsWith("Windows")) {
                    System.gc();
                }
                Path dataLocation = RocksDBStore.this.getLocation();
                Util.recursiveFileRemove((File)dataLocation.toFile());
                RocksDBStore.this.db = this.open(RocksDBStore.this.getLocation(), RocksDBStore.this.dataDbOptions());
                Path expirationLocation = RocksDBStore.this.getExpirationLocation();
                Util.recursiveFileRemove((File)expirationLocation.toFile());
                RocksDBStore.this.expiredDb = RocksDBStore.this.openDatabase(expirationLocation, RocksDBStore.this.expiredDbOptions());
            }
            finally {
                RocksDBStore.this.semaphore.release(Integer.MAX_VALUE);
            }
        }

        @Override
        protected RocksIterator wrapIterator(RocksDB db, ReadOptions readOptions, int segment) {
            return db.newIterator(this.defaultColumnFamilyHandle, readOptions);
        }

        @Override
        Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
            Predicate combinedFilter = org.infinispan.persistence.internal.PersistenceUtil.combinePredicate((IntSet)segments, (KeyPartitioner)this.keyPartitioner, filter);
            return this.publish(-1, it -> Flowable.fromIterable(() -> new RocksKeyIterator((RocksIterator)it, combinedFilter)));
        }

        @Override
        Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
            Predicate combinedFilter = org.infinispan.persistence.internal.PersistenceUtil.combinePredicate((IntSet)segments, (KeyPartitioner)this.keyPartitioner, filter);
            return this.publish(-1, it -> Flowable.fromIterable(() -> {
                long now = RocksDBStore.this.timeService.wallClockTime();
                return new RocksEntryIterator((RocksIterator)it, combinedFilter, fetchValue, fetchMetadata, now);
            }));
        }

        @Override
        void addSegments(IntSet segments) {
        }

        @Override
        void removeSegments(IntSet segments) {
            this.clear(segments);
        }
    }

    private abstract class RocksDBHandler {
        private RocksDBHandler() {
        }

        abstract RocksDB open(Path var1, DBOptions var2) throws RocksDBException;

        abstract void close();

        abstract ColumnFamilyHandle getHandle(int var1);

        final ColumnFamilyHandle getHandle(int segment, Object key) {
            if (segment < 0) {
                segment = this.calculateSegment(key);
            }
            return this.getHandle(segment);
        }

        abstract int calculateSegment(Object var1);

        ColumnFamilyDescriptor newDescriptor(byte[] name) {
            ColumnFamilyOptions columnFamilyOptions;
            if (RocksDBStore.this.columnFamilyProperties != null) {
                columnFamilyOptions = ColumnFamilyOptions.getColumnFamilyOptionsFromProps((Properties)RocksDBStore.this.columnFamilyProperties);
                if (columnFamilyOptions == null) {
                    throw log.rocksDBUnknownPropertiesSupplied(RocksDBStore.this.columnFamilyProperties.toString());
                }
            } else {
                columnFamilyOptions = new ColumnFamilyOptions();
            }
            return new ColumnFamilyDescriptor(name, columnFamilyOptions.setCompressionType(CompressionType.getCompressionType((String)RocksDBStore.this.configuration.compressionType().toString())));
        }

        boolean contains(int segment, Object key) {
            return this.load(segment, key) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MarshallableEntry<K, V> load(int segment, Object key) {
            ColumnFamilyHandle handle = this.getHandle(segment, key);
            if (handle == null) {
                log.trace("Ignoring load as handle is not currently configured");
                return null;
            }
            try {
                byte[] entryBytes;
                RocksDBStore.this.semaphore.acquire();
                try {
                    if (RocksDBStore.this.stopped) {
                        throw new PersistenceException("RocksDB is stopped");
                    }
                    entryBytes = RocksDBStore.this.db.get(handle, RocksDBStore.this.marshall(key));
                }
                finally {
                    RocksDBStore.this.semaphore.release();
                }
                MarshallableEntry me = RocksDBStore.this.valueToMarshallableEntry(key, entryBytes, true);
                if (me == null || me.isExpired(RocksDBStore.this.timeService.wallClockTime())) {
                    return null;
                }
                return me;
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write(int segment, MarshallableEntry<? extends K, ? extends V> me) {
            Object key = me.getKey();
            ColumnFamilyHandle handle = this.getHandle(segment, key);
            if (handle == null) {
                log.trace("Ignoring write as handle is not currently configured");
                return;
            }
            try {
                byte[] marshalledKey = MarshallUtil.toByteArray((ByteBuffer)me.getKeyBytes());
                byte[] marshalledValue = RocksDBStore.this.marshall(me.getMarshalledValue());
                RocksDBStore.this.semaphore.acquire();
                try {
                    if (RocksDBStore.this.stopped) {
                        throw new PersistenceException("RocksDB is stopped");
                    }
                    RocksDBStore.this.db.put(handle, marshalledKey, marshalledValue);
                }
                finally {
                    RocksDBStore.this.semaphore.release();
                }
                if (me.expiryTime() > -1L) {
                    RocksDBStore.this.addNewExpiry(me);
                }
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean delete(int segment, Object key) {
            try {
                byte[] keyBytes = RocksDBStore.this.marshall(key);
                RocksDBStore.this.semaphore.acquire();
                try {
                    if (RocksDBStore.this.stopped) {
                        throw new PersistenceException("RocksDB is stopped");
                    }
                    if (RocksDBStore.this.db.get(this.getHandle(segment, key), keyBytes) == null) {
                        boolean bl = false;
                        return bl;
                    }
                    RocksDBStore.this.db.delete(this.getHandle(segment, key), keyBytes);
                    return true;
                }
                finally {
                    RocksDBStore.this.semaphore.release();
                }
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }

        CompletionStage<Void> writeBatch(Publisher<MarshallableEntry<? extends K, ? extends V>> publisher) {
            return (CompletionStage)Flowable.fromPublisher(publisher).buffer(RocksDBStore.this.configuration.maxBatchSize()).doOnNext(entries -> {
                WriteBatch batch = new WriteBatch();
                for (MarshallableEntry entry : entries) {
                    int segment = this.calculateSegment(entry.getKey());
                    byte[] keyBytes = MarshallUtil.toByteArray((ByteBuffer)entry.getKeyBytes());
                    batch.put(this.getHandle(segment), keyBytes, RocksDBStore.this.marshall(entry.getMarshalledValue()));
                }
                this.writeBatch(batch);
                for (MarshallableEntry entry : entries) {
                    if (entry.expiryTime() <= -1L) continue;
                    RocksDBStore.this.addNewExpiry(entry);
                }
            }).doOnError(e -> {
                throw new PersistenceException(e);
            }).to(RxJavaInterop.flowableToCompletionStage());
        }

        void deleteBatch(Iterable<Object> keys) {
            try {
                int batchSize = 0;
                WriteBatch batch = new WriteBatch();
                for (Object key : keys) {
                    batch.remove(this.getHandle(this.calculateSegment(key)), RocksDBStore.this.marshall(key));
                    if (++batchSize != RocksDBStore.this.configuration.maxBatchSize()) continue;
                    batchSize = 0;
                    this.writeBatch(batch);
                    batch = new WriteBatch();
                }
                if (batchSize != 0) {
                    this.writeBatch(batch);
                }
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }

        abstract void clear(IntSet var1);

        abstract Publisher<K> publishKeys(IntSet var1, Predicate<? super K> var2);

        abstract Publisher<MarshallableEntry<K, V>> publishEntries(IntSet var1, Predicate<? super K> var2, boolean var3, boolean var4);

        int size(IntSet segments) {
            CompletionStage stage = (CompletionStage)Flowable.fromPublisher(this.publishKeys(segments, null)).count().to(RxJavaInterop.singleToCompletionStage());
            long count = (Long)CompletionStages.join((CompletionStage)stage);
            if (count > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)count;
        }

        <P> Flowable<P> publish(int segment, Function<RocksIterator, Flowable<P>> function) {
            ReadOptions readOptions = new ReadOptions().setFillCache(false);
            return Flowable.using(() -> {
                RocksDBStore.this.semaphore.acquire();
                if (RocksDBStore.this.stopped) {
                    throw new PersistenceException("RocksDB is stopped");
                }
                return this.wrapIterator(RocksDBStore.this.db, readOptions, segment);
            }, iterator -> {
                if (iterator == null) {
                    return Flowable.empty();
                }
                iterator.seekToFirst();
                return (Publisher)function.apply((RocksIterator)iterator);
            }, iterator -> {
                if (iterator != null) {
                    iterator.close();
                }
                readOptions.close();
                RocksDBStore.this.semaphore.release();
            });
        }

        abstract RocksIterator wrapIterator(RocksDB var1, ReadOptions var2, int var3);

        private void writeBatch(WriteBatch batch) throws InterruptedException, RocksDBException {
            RocksDBStore.this.semaphore.acquire();
            try {
                if (RocksDBStore.this.stopped) {
                    throw new PersistenceException("RocksDB is stopped");
                }
                RocksDBStore.this.db.write(RocksDBStore.this.dataWriteOptions(), batch);
            }
            finally {
                batch.close();
                RocksDBStore.this.semaphore.release();
            }
        }

        abstract void addSegments(IntSet var1);

        abstract void removeSegments(IntSet var1);
    }

    private class RocksEntryIterator
    extends AbstractIterator<MarshallableEntry<K, V>> {
        private final RocksIterator it;
        private final Predicate<? super K> filter;
        private final boolean fetchValue;
        private final boolean fetchMetadata;
        private final long now;

        public RocksEntryIterator(RocksIterator it, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata, long now) {
            this.it = it;
            this.filter = filter;
            this.fetchValue = fetchValue;
            this.fetchMetadata = fetchMetadata;
            this.now = now;
        }

        protected MarshallableEntry<K, V> getNext() {
            MarshallableEntry entry = null;
            try {
                while (entry == null && this.it.isValid()) {
                    Object key = RocksDBStore.this.unmarshall(this.it.key());
                    if (this.filter == null || this.filter.test(key)) {
                        if (this.fetchValue || this.fetchMetadata) {
                            MarshallableEntry me = RocksDBStore.this.valueToMarshallableEntry(key, this.it.value(), this.fetchMetadata);
                            if (me != null && !me.isExpired(this.now)) {
                                entry = me;
                            }
                        } else {
                            entry = RocksDBStore.this.entryFactory.create(key);
                        }
                    }
                    this.it.next();
                }
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
            return entry;
        }
    }

    private class RocksKeyIterator
    extends AbstractIterator<K> {
        private final RocksIterator it;
        private final Predicate<? super K> filter;

        public RocksKeyIterator(RocksIterator it, Predicate<? super K> filter) {
            this.it = it;
            this.filter = filter;
        }

        protected K getNext() {
            Object key = null;
            try {
                while (key == null && this.it.isValid()) {
                    Object testKey = RocksDBStore.this.unmarshall(this.it.key());
                    if (this.filter == null || this.filter.test(testKey)) {
                        key = testKey;
                    }
                    this.it.next();
                }
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
            return key;
        }
    }

    private static final class ExpiryEntry {
        long expiry;
        byte[] keyBytes;

        ExpiryEntry(long expiry, byte[] keyBytes) {
            this.expiry = expiry;
            this.keyBytes = keyBytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpiryEntry that = (ExpiryEntry)o;
            return this.expiry == that.expiry && Arrays.equals(this.keyBytes, that.keyBytes);
        }

        public int hashCode() {
            int result = Objects.hash(this.expiry);
            result = 31 * result + Arrays.hashCode(this.keyBytes);
            return result;
        }
    }

    @ProtoTypeId(value=5100)
    static final class ExpiryBucket {
        @ProtoField(number=1, collectionImplementation=ArrayList.class)
        List<byte[]> entries;

        ExpiryBucket() {
        }

        ExpiryBucket(byte[] existingKey, byte[] newKey) {
            this.entries = new ArrayList<byte[]>(2);
            this.entries.add(existingKey);
            this.entries.add(newKey);
        }
    }
}

