/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    BLOCK_SIZE("block-size"),
    CACHE_SIZE("cache-size"),
    CLEAR_THRESHOLD("clear-threshold"),
    COMPRESSION_TYPE("compressionType"),
    EXPIRED_LOCATION("expiredLocation"),
    EXPIRY_QUEUE_SIZE("expiryQueueSize"),
    IMPLEMENTATION_TYPE("implementationType"),
    LOCATION("location"),
    PATH("path"),
    RELATIVE_TO("relative-to"),
    QUEUE_SIZE("queue-size"),
    TYPE("type");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

